/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.renderer.particle;

import net.lrsoft.mets.block.tileentity.TileEntityWirelessPowerTransmissionNode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityParticleGroup
extends Entity {
    protected EntityPlayer shooter;
    protected int ticksInAir = 0;
    protected int maxExistTicks;
    protected int spawnParticles;
    protected int spawnParticlesPerTick;
    protected float velocity;

    public EntityParticleGroup(World world) {
        super(world);
        this.func_70105_a(0.39f, 0.39f);
        this.maxExistTicks = 0;
        this.spawnParticles = 0;
        this.spawnParticlesPerTick = 0;
    }

    public EntityParticleGroup(World world, EntityPlayer owner, int maxTick, int spawnParticles, int spawnParticlesPerTick) {
        super(world);
        this.shooter = owner;
        this.func_70105_a(0.39f, 0.39f);
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u + (double)this.shooter.func_70047_e() - 0.1, owner.field_70161_v);
        this.maxExistTicks = maxTick;
        this.spawnParticles = spawnParticles;
        this.spawnParticlesPerTick = spawnParticlesPerTick;
    }

    public EntityParticleGroup(World world, Vec3d postion, int maxTick, int spawnParticles, int spawnParticlesPerTick) {
        super(world);
        this.func_70105_a(0.39f, 0.39f);
        this.func_70107_b(postion.field_72450_a, postion.field_72448_b, postion.field_72449_c);
        this.maxExistTicks = maxTick;
        this.spawnParticles = spawnParticles;
        this.spawnParticlesPerTick = spawnParticlesPerTick;
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        TileEntity te = this.field_70170_p.func_175625_s(blockpos);
        if (iblockstate.func_185904_a() != Material.field_151579_a && !(te instanceof TileEntityWirelessPowerTransmissionNode) && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir > this.maxExistTicks) {
            this.func_70106_y();
            return;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void shoot(float yaw, float pitch, float velocity) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity);
        this.field_70159_w += this.shooter.field_70159_w;
        this.field_70181_x += this.shooter.field_70181_x;
        this.field_70179_y += this.shooter.field_70179_y;
        this.velocity = velocity;
    }

    public void shoot(Vec3d pos, Vec3d target) {
        double d1 = (target.field_72450_a - pos.field_72450_a) / 8.0;
        double d2 = (target.field_72448_b - pos.field_72448_b) / 8.0;
        double d3 = (target.field_72449_c - pos.field_72449_c) / 8.0;
        double d4 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
        this.shoot(d1, d2 + d4, d3, 1.0f);
    }

    public void shoot(double x, double y, double z, float velocity) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * 0.1;
        y += this.field_70146_Z.nextGaussian() * 0.1;
        z += this.field_70146_Z.nextGaussian() * 0.1;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public int getParticleSpawnCount() {
        return this.spawnParticles;
    }

    public int getParticleSpawnPerTick() {
        return this.spawnParticlesPerTick;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ticksInAir = compound.func_74762_e("ticksInAir");
        this.spawnParticles = compound.func_74762_e("spawnParticles");
        this.velocity = compound.func_74760_g("velocity");
        this.maxExistTicks = compound.func_74762_e("maxExistTicks");
        this.spawnParticlesPerTick = compound.func_74762_e("spawnParticlesPerTick");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("ticksInAir", this.ticksInAir);
        compound.func_74768_a("spawnParticles", this.spawnParticles);
        compound.func_74768_a("spawnParticlesPerTick", this.spawnParticlesPerTick);
        compound.func_74776_a("velocity", this.velocity);
        compound.func_74768_a("maxExistTicks", this.maxExistTicks);
    }
}

