/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.renderer.particle;

import net.lrsoft.mets.renderer.particle.IXCustomizedEffect;
import net.lrsoft.mets.util.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class XCustomizedParticle
implements IXCustomizedEffect {
    private static ResourceLocation resourceLocation = new ResourceLocation("mets", "textures/particles/particle.png");
    private Vec3d color;
    private Vec3d worldLocation;
    private Vec3d motion;
    private Vec3d scale;
    private Vec3d rotate;
    private float angle;
    private int maxTicks;
    private int currentTicks;

    public XCustomizedParticle(Vec3d color, Vec3d worldLocation, Vec3d motion, Vec3d scale, Vec3d rotate, float angle, int maxTicks) {
        this.color = color;
        this.worldLocation = worldLocation;
        this.motion = motion;
        this.scale = scale;
        this.rotate = rotate;
        this.angle = angle;
        this.maxTicks = maxTicks;
        this.currentTicks = 0;
    }

    @Override
    public void onRender(float partialTicks) {
        if (this.currentTicks < this.maxTicks) {
            this.onRenderInside(this.worldLocation.field_72450_a, this.worldLocation.field_72448_b, this.worldLocation.field_72449_c, partialTicks);
            this.worldLocation = this.worldLocation.func_178787_e(this.motion);
            ++this.currentTicks;
        }
    }

    private void onRenderInside(double x, double y, double z, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP viewer = minecraft.field_71439_g;
        float[] info = MathUtils.getPlayerView((EntityPlayer)viewer, partialTicks);
        float alpha = 1.0f - (float)this.currentTicks / (float)this.maxTicks;
        int red = (int)this.color.field_72450_a;
        int blue = (int)this.color.field_72448_b;
        int green = (int)this.color.field_72449_c;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)1);
        GlStateManager.func_179132_a((boolean)true);
        RenderHelper.func_74519_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        minecraft.func_110434_K().func_110577_a(resourceLocation);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.angle, (float)((float)this.rotate.field_72450_a), (float)((float)this.rotate.field_72448_b), (float)((float)this.rotate.field_72449_c));
        GlStateManager.func_179114_b((float)(180.0f - info[1]), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? -1 : 1) * -info[0]), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)this.scale.field_72450_a, (double)this.scale.field_72448_b, (double)this.scale.field_72449_c);
        this.particleRender(red, green, blue, alpha);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
    }

    public void onSpecialRender(double x, double y, double z, float partialTicks) {
        if (this.currentTicks < this.maxTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP viewer = minecraft.field_71439_g;
            float[] info = MathUtils.getPlayerView((EntityPlayer)viewer, partialTicks);
            float alpha = 1.0f - (float)this.currentTicks / (float)this.maxTicks;
            int red = (int)this.color.field_72450_a;
            int blue = (int)this.color.field_72448_b;
            int green = (int)this.color.field_72449_c;
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)1, (int)1);
            GlStateManager.func_179132_a((boolean)true);
            RenderHelper.func_74519_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)this.worldLocation.field_72450_a, (double)this.worldLocation.field_72448_b, (double)this.worldLocation.field_72449_c);
            minecraft.func_110434_K().func_110577_a(resourceLocation);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.angle, (float)((float)this.rotate.field_72450_a), (float)((float)this.rotate.field_72448_b), (float)((float)this.rotate.field_72449_c));
            GlStateManager.func_179114_b((float)(180.0f - info[1]), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? -1 : 1) * -info[0]), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)this.scale.field_72450_a, (double)this.scale.field_72448_b, (double)this.scale.field_72449_c);
            this.particleRender(red, green, blue, alpha);
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            this.worldLocation = this.worldLocation.func_178787_e(this.motion);
            ++this.currentTicks;
        }
    }

    private void particleRender(int red, int green, int blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-0.5, -0.25, 0.0).func_187315_a(0.0, 0.0).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(0.5, -0.25, 0.0).func_187315_a(1.0, 0.0).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(0.5, 0.75, 0.0).func_187315_a(1.0, 1.0).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(-0.5, 0.75, 0.0).func_187315_a(0.0, 1.0).func_181666_a((float)red, (float)green, (float)blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public boolean getIsFinish() {
        return this.currentTicks >= this.maxTicks;
    }
}

