/*
 * Decompiled with CFR 0.152.
 */
package net.lrsoft.mets.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MathUtils {
    public static int getRandomFromRange(int max, int min) {
        return new Random().nextInt(max - min) + min;
    }

    public static double getRandomFromRange(double max, double min) {
        return Math.random() * (max - min) + min;
    }

    public static float[] getPlayerView(EntityPlayer player, float partialTicks) {
        float[] playerView = new float[2];
        playerView[1] = 0.0f;
        playerView[0] = 0.0f;
        World worldIn = player.field_70170_p;
        if (player.func_70608_bn()) {
            IBlockState iblockstate = worldIn.func_180495_p(new BlockPos((Entity)player));
            Block block = iblockstate.func_177230_c();
            if (block.isBed(iblockstate, (IBlockAccess)worldIn, new BlockPos((Entity)player), (Entity)player)) {
                int i = block.getBedDirection(iblockstate, (IBlockAccess)worldIn, new BlockPos((Entity)player)).func_176736_b();
                playerView[1] = i * 90 + 180;
                playerView[0] = 0.0f;
            }
        } else {
            playerView[1] = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks;
            playerView[0] = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2) {
            playerView[1] = playerView[1] + 180.0f;
        }
        return playerView;
    }

    public static float[] getRenderXYUV(int column, int row, float imageX, float imageY, float xcoord, float ycoord) {
        float x = imageX;
        float y = imageY;
        float icol = column;
        float irow = row;
        float[] returnArray = new float[]{xcoord, ycoord, x / icol, y / irow, xcoord, -ycoord, x / icol, (y - 1.0f) / irow, -xcoord, -ycoord, (x - 1.0f) / icol, (y - 1.0f) / irow, -xcoord, ycoord, (x - 1.0f) / icol, y / irow};
        return returnArray;
    }

    public static boolean getChance(int percentage) {
        Random random = new Random();
        int i = random.nextInt(99);
        return i >= 0 && i < percentage;
    }
}

