/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.blocks.BlockAriadneCoal;
import wile.engineerstools.items.ItemAriadneCoal;
import wile.engineerstools.items.ItemCrushingHammer;
import wile.engineerstools.items.ItemGrit;
import wile.engineerstools.items.ItemRediaTool;
import wile.engineerstools.items.ItemSleepingBag;
import wile.engineerstools.items.ItemStimPack;

public class ModContent {
    public static final BlockAriadneCoal ARIADNE_COAL_X = new BlockAriadneCoal("ariadne_coal_x", EnumFacing.Axis.X);
    public static final BlockAriadneCoal ARIADNE_COAL_Y = new BlockAriadneCoal("ariadne_coal_y", EnumFacing.Axis.Y);
    public static final BlockAriadneCoal ARIADNE_COAL_Z = new BlockAriadneCoal("ariadne_coal_z", EnumFacing.Axis.Z);
    private static final Object[] content_blocks = new Object[]{ARIADNE_COAL_X, ARIADNE_COAL_Y, ARIADNE_COAL_Z};
    private static ArrayList<Block> registeredBlocks = new ArrayList();
    public static final ItemCrushingHammer CRUSHING_HAMMER = new ItemCrushingHammer("crushing_hammer");
    public static final ItemRediaTool REDIA_TOOL = new ItemRediaTool("redia_tool");
    public static final ItemGrit IRON_GRIT = new ItemGrit("iron_grit");
    public static final ItemGrit GOLD_GRIT = new ItemGrit("gold_grit");
    public static final ItemAriadneCoal ARIADNE_COAL = new ItemAriadneCoal("ariadne_coal");
    public static final ItemStimPack STIMPACK = new ItemStimPack("stimpack");
    public static final ItemSleepingBag SLEEPING_BAG = new ItemSleepingBag("sleeping_bag");
    private static final Item[] modItems = new Item[]{CRUSHING_HAMMER, REDIA_TOOL, IRON_GRIT, GOLD_GRIT, ARIADNE_COAL, STIMPACK, SLEEPING_BAG};
    private static final ArrayList<Item> registeredItems = new ArrayList();

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(registeredBlocks);
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(registeredItems);
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        Collections.addAll(registeredItems, modItems);
        for (Item e : registeredItems) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        ModEngineersTools.logger.info("Registered " + Integer.toString(registeredItems.size()) + " items.");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Item item, Object ... args) {
        if (args.length == 0) {
            if (item instanceof ItemRediaTool) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            } else {
                ModelResourceLocation rc = new ModelResourceLocation(item.getRegistryName(), "inventory");
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{rc});
                ModelLoader.setCustomMeshDefinition((Item)item, stack -> rc);
            }
        } else {
            ModEngineersTools.logger.error("Invalid registerItemModel() args");
        }
    }

    public static final void registerBlocks(RegistryEvent.Register<Block> event) {
        boolean num_block_registrations_skipped = false;
        boolean num_block_registrations_skipped_noie = false;
        for (Object e : content_blocks) {
            if (!(e instanceof Block)) continue;
            registeredBlocks.add((Block)e);
        }
        for (Block e : registeredBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
        ModEngineersTools.logger.info("Registered " + Integer.toString(registeredBlocks.size()) + " blocks.");
    }

    public static final void registerItemBlocks(RegistryEvent.Register<Item> event) {
        int n = 0;
        for (Block e : registeredBlocks) {
            ResourceLocation rl = e.getRegistryName();
            if (rl == null) continue;
            event.getRegistry().register(new ItemBlock(e).setRegistryName(rl));
            ++n;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final void initModels() {
        for (Item item : registeredItems) {
            ModContent.registerItemModel(item, new Object[0]);
        }
        for (Block block : registeredBlocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
    }
}

