/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.ModContent;
import wile.engineerstools.detail.BlockCategories;
import wile.engineerstools.detail.ModConfig;
import wile.engineerstools.detail.RecipeCondModSpecific;
import wile.engineerstools.items.ItemCrushingHammer;
import wile.engineerstools.items.ItemSleepingBag;

@Mod(modid="engineerstools", name="Engineer's Tools", version="1.0.5", dependencies="required-after:forge@[14.23.5.2768,);before:immersiveengineering", useMetadata=true, updateJSON="https://raw.githubusercontent.com/stfwi/engineerstools/develop/meta/update.json", certificateFingerprint="", acceptedMinecraftVersions="[1.12.2]")
public class ModEngineersTools {
    public static final String MODID = "engineerstools";
    public static final String MODNAME = "Engineer's Tools";
    public static final String MODVERSION = "1.0.5";
    public static final String MODMCVERSION = "1.12.2";
    public static final String MODFINGERPRINT = "@MOD_SIGNSHA1@";
    public static final String MODBUILDID = "#ab951e3";
    public static Logger logger;
    @Mod.Instance
    public static ModEngineersTools instance;
    @SidedProxy(clientSide="wile.engineerstools.detail.ClientProxy", serverSide="wile.engineerstools.detail.ServerProxy")
    public static IProxy proxy;
    public static final CreativeTabs CREATIVE_TAB_ENGINEERSTOOLS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Engineer's Tools: Version 1.12.2-1.0.5 #ab951e3.");
        logger.warn("Engineer's Tools: Mod is NOT signed by the author.");
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModConfig.onPostInit(event);
        proxy.postInit(event);
        if (RecipeCondModSpecific.num_skipped > 0) {
            logger.info("Excluded " + RecipeCondModSpecific.num_skipped + " recipes due to config opt-out.");
        }
        if (ModConfig.zmisc.with_experimental) {
            logger.info("Included experimental features due to mod config.");
        }
        BlockCategories.reload();
    }

    static {
        CREATIVE_TAB_ENGINEERSTOOLS = new CreativeTabs("tabengineerstools"){

            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((Item)ModContent.CRUSHING_HAMMER);
            }
        };
    }

    @Mod.EventBusSubscriber
    public static class PlayerEventHandler {
        public static void update(LivingEvent.LivingUpdateEvent event) {
            if (!(event.getEntity() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_70170_p == null) {
                return;
            }
        }

        @SubscribeEvent
        public static void onBedCheck(SleepingLocationCheckEvent event) {
            ItemSleepingBag.onBedCheck(event);
        }
    }

    @Mod.EventBusSubscriber
    public static final class RegistrationSubscriptions {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModContent.registerItemBlocks(event);
            ModContent.registerItems(event);
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            ItemCrushingHammer.CrushingHammerRecipe.registerAll(event);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ModContent.initModels();
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }
    }

    public static interface IProxy {
        default public void preInit(FMLPreInitializationEvent e) {
        }

        default public void init(FMLInitializationEvent e) {
        }

        default public void postInit(FMLPostInitializationEvent e) {
        }

        default public World getWorldClientSide() {
            return null;
        }
    }
}

