/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.detail;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wile.engineerstools.ModContent;
import wile.engineerstools.items.ItemCrushingHammer;
import wile.engineerstools.items.ItemRediaTool;

@Config(modid="engineerstools")
@Config.LangKey(value="engineerstools.config.title")
public class ModConfig {
    @Config.Comment(value={"Allows disabling specific features."})
    @Config.Name(value="Feature opt-outs")
    public static final SettingsOptouts optout = new SettingsOptouts();
    @Config.Comment(value={"Settings for beta testing and trouble shooting. Some of the settings may be moved to other categories after testing."})
    @Config.Name(value="Miscellaneous")
    public static final SettingsZTesting zmisc = new SettingsZTesting();
    @Config.Comment(value={"Tweaks and item behaviour adaptions."})
    @Config.Name(value="Tweaks")
    public static final SettingsTweaks tweaks = new SettingsTweaks();

    public static final void onPostInit(FMLPostInitializationEvent event) {
        ModConfig.apply();
    }

    public static final boolean isWithoutRecipes() {
        return zmisc == null || ModConfig.zmisc.without_recipes;
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        if (item == null || optout == null) {
            return true;
        }
        return ModConfig.optout.without_crushing_hammer && item == ModContent.CRUSHING_HAMMER;
    }

    public static final void apply() {
        ItemCrushingHammer.on_config("immersiveengineering", ModConfig.tweaks.crushing_hammer_wearoff, 2);
        ItemRediaTool.on_config(ModConfig.optout.without_redia_torchplacing, ModConfig.optout.without_redia_hoeing, ModConfig.optout.without_redia_tree_chopping, ModConfig.tweaks.redia_durability, ModConfig.tweaks.redia_efficiency_curve, ModConfig.tweaks.redia_fortune_curve);
    }

    @Mod.EventBusSubscriber(modid="engineerstools")
    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (!event.getModID().equals("engineerstools")) {
                return;
            }
            ConfigManager.sync((String)"engineerstools", (Config.Type)Config.Type.INSTANCE);
            ModConfig.apply();
        }
    }

    public static final class SettingsTweaks {
        @Config.Comment(value={"Defines how much durability the ore crushing hammer loses for each ore block it processes to grit."})
        @Config.Name(value="Crushing hammer: Wear-off")
        @Config.RangeInt(min=1, max=32)
        public int crushing_hammer_wearoff = 2;
        @Config.Comment(value={"Defines how much durability REDIA tool has."})
        @Config.Name(value="REDIA tool: Durability")
        @Config.RangeInt(min=800, max=3000)
        public int redia_durability = 2200;
        @Config.Comment(value={"Defines the efficiency scaling depending on the durability. ", "Ten values have to given in precent, (between 10 and 250), and the curve must be rising left-to-right. 100% corresponds to vanilla diamond tools. The first number specifies the efficiency factor between 0% and 10% durability, second 10% to 20%, last 90% to 100%."})
        @Config.Name(value="REDIA tool: Dur-Eff curve")
        public String redia_efficiency_curve = "10,60,90,100,120,140,170,200,220,230";
        @Config.Comment(value={"Defines the fortune depending on the durability. ", "Ten values have to given as integer numbers, (between 0 and 3), and the curve must be rising left-to-right."})
        @Config.Name(value="REDIA tool: Dur-Fortune curve")
        public String redia_fortune_curve = "0,0,0,0,0,1,2,2,3,3";
    }

    public static final class SettingsZTesting {
        @Config.Comment(value={"Enables experimental features. Use at own risk."})
        @Config.Name(value="With experimental")
        @Config.RequiresMcRestart
        public boolean with_experimental = false;
        @Config.Comment(value={"Disable all internal recipes, allowing to use alternative pack recipes."})
        @Config.Name(value="Without recipes")
        @Config.RequiresMcRestart
        public boolean without_recipes = false;
    }

    public static final class SettingsOptouts {
        @Config.Comment(value={"Disable ore-duping crushing hammer."})
        @Config.Name(value="Without crushing hammer")
        @Config.RequiresMcRestart
        public boolean without_crushing_hammer = false;
        @Config.Comment(value={"Disable upward vein chopping of the REDIA tool."})
        @Config.Name(value="Without REDIA tree chopping")
        public boolean without_redia_tree_chopping = false;
        @Config.Comment(value={"Disable hoeing function of the REDIA tool."})
        @Config.Name(value="Without REDIA hoeing")
        public boolean without_redia_hoeing = false;
        @Config.Comment(value={"Disable torch placing function of the REDIA tool."})
        @Config.Name(value="Without REDIA torch placing")
        public boolean without_redia_torchplacing = false;
    }
}

