/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import wile.engineerstools.detail.ModResources;
import wile.engineerstools.eapi.baubles.IBaubleItem;
import wile.engineerstools.items.ItemTools;

public class ItemStimPack
extends ItemTools
implements IBaubleItem {
    private static int max_uses = 2;
    private static float trigger_threshold_health = 3.0f;
    private static float instant_healing_health = 3.0f;

    public ItemStimPack(String registryName) {
        super(registryName);
        this.func_77625_d(1);
        this.func_77656_e(2);
        this.setNoRepair();
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer) {
            this.inventoryTick(stack, world, (EntityPlayer)entity, itemSlot);
        }
    }

    @Override
    public void onBaubleTick(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.inventoryTick(stack, entity.func_130014_f_(), (EntityPlayer)entity, -1);
        }
    }

    private void inventoryTick(ItemStack stimpack, World world, EntityPlayer player, int itemSlot) {
        NBTTagCompound nbt = stimpack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("cd")) {
            int t;
            if (nbt.func_74764_b("ta")) {
                nbt.func_82580_o("ta");
            }
            if ((t = nbt.func_74762_e("cd")) > 0) {
                nbt.func_74768_a("cd", t - 1);
            } else {
                nbt.func_82580_o("cd");
                if (nbt.func_186856_d() == 0) {
                    nbt = null;
                }
            }
        } else {
            float health = player.func_110143_aJ();
            if (health > trigger_threshold_health * 2.0f || player.field_70128_L) {
                return;
            }
            int t = nbt.func_74762_e("ta");
            if (t < 20) {
                if (t == 2) {
                    world.func_184133_a(player, player.func_180425_c(), ModResources.STIMPACK_INJECT_SOUND, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                nbt.func_74768_a("ta", t + 1);
            } else {
                nbt.func_82580_o("ta");
                if (!world.field_72995_K) {
                    int dmg = stimpack.func_77952_i() + 1;
                    if (dmg >= stimpack.func_77958_k()) {
                        stimpack.func_190918_g(1);
                    } else {
                        stimpack.func_77964_b(dmg);
                    }
                    player.func_70606_j(health + instant_healing_health * 2.0f);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 400));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 300));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200));
                }
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack other;
                if (i == itemSlot || !(other = player.field_71071_by.func_70301_a(i)).func_185136_b(stimpack)) continue;
                NBTTagCompound other_nbt = other.func_77978_p();
                if (other_nbt == null) {
                    other_nbt = new NBTTagCompound();
                }
                other_nbt.func_82580_o("ta");
                other_nbt.func_74768_a("cd", 30);
            }
            nbt.func_82580_o("cd");
            if (nbt.func_186856_d() == 0) {
                stimpack.func_77982_d(null);
            }
            if (!world.field_72995_K) {
                player.field_71071_by.func_70296_d();
            }
        }
        stimpack.func_77982_d(nbt);
    }
}

