/*
 * Decompiled with CFR 0.152.
 */
package yako.portabledrill.init;

import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import yako.portabledrill.PortableDrill;

public class Config {
    public static int MAX_ENERGY;
    public static int MAX_INSERT;
    public static int CONSUMPTION;
    public static boolean SAMPLE_MODE;
    private static final String CATEGORY_DRILL = "Drill";

    public static void readConfig() {
        Configuration cfg = PortableDrill.config;
        try {
            cfg.load();
            Config.initDrillConfig(cfg);
        }
        catch (Exception e1) {
            PortableDrill.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initDrillConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_DRILL, "General configuration");
        MAX_ENERGY = cfg.getInt("MAX_ENERGY", CATEGORY_DRILL, 10000, 0, Integer.MAX_VALUE, "Energy that the portable drill can store");
        MAX_INSERT = cfg.getInt("MAX_INSERT", CATEGORY_DRILL, 2000, 0, Integer.MAX_VALUE, "Rate at which energy can be inserted into the item");
        CONSUMPTION = cfg.getInt("CONSUMPTION", CATEGORY_DRILL, 500, 0, Integer.MAX_VALUE, "Energy that will be consumed per scan");
        SAMPLE_MODE = cfg.getBoolean("SAMPLE_MODE", CATEGORY_DRILL, false, "If set to true, the drill will output a sample instead of a chat message");
    }
}

