/*
 * Decompiled with CFR 0.152.
 */
package yako.portabledrill.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yako.portabledrill.PortableDrill;
import yako.portabledrill.init.Config;
import yako.portabledrill.util.CapabilityHandlerDrill;
import yako.portabledrill.util.DrillHelper;

public class ItemDrill
extends Item {
    public ItemDrill() {
        this.setRegistryName("portabledrill", "portable_drill");
        this.func_77655_b("portabledrill.portable_drill");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(ImmersiveEngineering.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ActionResult res = new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        if (worldIn.field_72995_K) {
            return res;
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!DrillHelper.isValid(stack)) {
            return res;
        }
        if (!playerIn.func_184812_l_() && !DrillHelper.tryConsumePower(stack)) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Not enough energy! You need at least " + TextFormatting.AQUA + Config.CONSUMPTION));
            return res;
        }
        boolean mineral_present = false;
        boolean oil_present = false;
        ExcavatorHandler.MineralWorldInfo worldInfo = ExcavatorHandler.getMineralWorldInfo((World)worldIn, (int)playerIn.field_70176_ah, (int)playerIn.field_70164_aj);
        ExcavatorHandler.MineralMix mix = DrillHelper.getValidMineral(worldInfo);
        if (mix != null) {
            mineral_present = true;
        }
        PumpjackHandler.ReservoirType reservoirType = null;
        if (PortableDrill.immersivePetroleumPresent) {
            PumpjackHandler.OilWorldInfo worldInfoOil = PumpjackHandler.getOilWorldInfo((World)worldIn, (int)playerIn.field_70176_ah, (int)playerIn.field_70164_aj);
            reservoirType = DrillHelper.getValidReservoir(worldInfoOil);
            if (reservoirType != null) {
                oil_present = true;
            }
            if (Config.SAMPLE_MODE) {
                ItemStack sample = new ItemStack((Item)IEContent.itemCoresample);
                ItemNBTHelper.setLong((ItemStack)sample, (String)"timestamp", (long)worldIn.func_82737_E());
                ItemNBTHelper.setIntArray((ItemStack)sample, (String)"coords", (int[])new int[]{worldIn.field_73011_w.getDimension(), playerIn.field_70176_ah, playerIn.field_70164_aj});
                if (mineral_present) {
                    sample = DrillHelper.genMineralSample(sample, worldInfo);
                }
                if (PortableDrill.immersivePetroleumPresent && oil_present) {
                    sample = DrillHelper.genOilSample(sample, worldInfoOil);
                }
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)playerIn.func_180425_c().func_177958_n(), (double)playerIn.func_180425_c().func_177956_o(), (double)playerIn.func_180425_c().func_177952_p(), sample));
                return res;
            }
        }
        if (mineral_present) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Mineral-Mix present: " + TextFormatting.AQUA + mix.name));
        } else {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "No minerals found!"));
        }
        if (PortableDrill.immersivePetroleumPresent) {
            if (oil_present) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Fluid-Reservoir present: " + TextFormatting.AQUA + reservoirType.name.substring(0, 1).toUpperCase() + reservoirType.name.substring(1)));
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "No reservoir found!"));
            }
        }
        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GRAY + "------------------------------------"));
        return res;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int energy = stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy") ? stack.func_77978_p().func_74762_e("Energy") : 0;
        tooltip.add(TextFormatting.GOLD + "Energy: " + TextFormatting.AQUA + energy + TextFormatting.DARK_GRAY + "/" + TextFormatting.DARK_AQUA + Config.MAX_ENERGY);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab.func_78013_b() == "immersiveengineering") {
            ItemStack it = new ItemStack((Item)this);
            ((CapabilityHandlerDrill.EnergyStorageDrill)((Object)it.getCapability(CapabilityEnergy.ENERGY, null))).setEnergy(Config.MAX_ENERGY);
            items.add((Object)it);
        }
        super.func_150895_a(tab, items);
    }
}

