/*
 * Decompiled with CFR 0.152.
 */
package yako.portabledrill.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import yako.portabledrill.init.Config;

public class CapabilityHandlerDrill
implements ICapabilitySerializable<NBTBase> {
    @CapabilityInject(value=IEnergyStorage.class)
    private static final Capability<IEnergyStorage> ENERGY_CAPABILITY = null;
    private EnergyStorageDrill ENERGY_STORAGE = new EnergyStorageDrill(Config.MAX_ENERGY, Config.MAX_INSERT, 0, this.getNBTEnergy());
    private ItemStack drill;

    public CapabilityHandlerDrill(ItemStack drill) {
        this.drill = drill;
    }

    private int getNBTEnergy() {
        return this.drill != null && this.drill.func_77942_o() && this.drill.func_77978_p().func_74764_b("Energy") ? this.drill.func_77978_p().func_74762_e("Energy") : 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.ENERGY_STORAGE);
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return ENERGY_CAPABILITY.writeNBT((Object)this.ENERGY_STORAGE, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        ENERGY_CAPABILITY.readNBT((Object)this.ENERGY_STORAGE, null, nbt);
    }

    public class EnergyStorageDrill
    extends EnergyStorage {
        public EnergyStorageDrill(int capacity, int maxReceive, int maxExtract, int energy) {
            super(capacity, maxReceive, maxExtract, energy);
        }

        public void setEnergy(int energy) {
            this.energy = energy;
            this.onEnergyChanged();
        }

        public boolean canExtract() {
            return false;
        }

        public void onEnergyChanged() {
            NBTTagCompound nbt = CapabilityHandlerDrill.this.drill.func_77942_o() ? CapabilityHandlerDrill.this.drill.func_77978_p() : new NBTTagCompound();
            nbt.func_74768_a("Energy", this.getEnergyStored());
            CapabilityHandlerDrill.this.drill.func_77982_d(nbt);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            this.onEnergyChanged();
            return received;
        }
    }
}

