/*
 * Decompiled with CFR 0.152.
 */
package yako.portabledrill.util;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import yako.portabledrill.init.Config;
import yako.portabledrill.init.ModItems;

public class DrillHelper {
    public static boolean isValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() == ModItems.DRILL && stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public static boolean tryConsumePower(ItemStack stack) {
        int remaining = ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() - Config.CONSUMPTION;
        if (remaining >= 0) {
            ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(-Config.CONSUMPTION, false);
            return true;
        }
        return false;
    }

    public static ItemStack genMineralSample(ItemStack sample, ExcavatorHandler.MineralWorldInfo mineral) {
        ExcavatorHandler.MineralMix mix = DrillHelper.getValidMineral(mineral);
        if (mix != null) {
            ItemNBTHelper.setString((ItemStack)sample, (String)"mineral", (String)mix.name);
            if (ExcavatorHandler.mineralVeinCapacity < 0 || mineral.depletion < 0) {
                ItemNBTHelper.setBoolean((ItemStack)sample, (String)"infinite", (boolean)true);
            } else {
                ItemNBTHelper.setInt((ItemStack)sample, (String)"depletion", (int)mineral.depletion);
            }
        }
        return sample;
    }

    public static ItemStack genOilSample(ItemStack sample, PumpjackHandler.OilWorldInfo oil) {
        if (DrillHelper.getValidReservoir(oil) != null) {
            ItemNBTHelper.setString((ItemStack)sample, (String)"resType", (String)oil.getType().name);
            ItemNBTHelper.setInt((ItemStack)sample, (String)"oil", (int)oil.current);
        }
        return sample;
    }

    public static ExcavatorHandler.MineralMix getValidMineral(ExcavatorHandler.MineralWorldInfo info) {
        ExcavatorHandler.MineralMix mix = null;
        if (info != null) {
            if (info.mineral != null) {
                mix = info.mineral;
            }
            if (info.mineralOverride != null) {
                mix = info.mineralOverride;
            }
        }
        return mix;
    }

    public static PumpjackHandler.ReservoirType getValidReservoir(PumpjackHandler.OilWorldInfo info) {
        PumpjackHandler.ReservoirType reservoirType = null;
        if (info != null) {
            if (info.getType() != null) {
                reservoirType = info.getType();
            }
            if (info.overrideType != null) {
                reservoirType = info.overrideType;
            }
        }
        return reservoirType;
    }
}

