/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class Sphere {
    private final Biome biome;
    private final BlockPos center;
    private final int radius;
    private final boolean village;

    public Sphere(BlockPos center, int radius, Biome biome, boolean village) {
        this.center = center;
        this.radius = radius;
        this.biome = biome;
        this.village = village;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public int getRadius() {
        return this.radius;
    }

    public int hashCode() {
        return (this.biome.hashCode() * 3 + this.center.hashCode()) * 3 + this.radius;
    }

    public boolean equals(Object o) {
        if (o instanceof Sphere) {
            Sphere other = (Sphere)o;
            return other.radius == this.radius && other.center.equals((Object)this.center) && other.biome == this.biome;
        }
        return true;
    }

    public IBlockState getBlockState(BlockPos pos) {
        int innerRadius;
        IBlockState outer = null;
        IBlockState inner = null;
        if (pos.func_177956_o() <= this.center.func_177956_o()) {
            innerRadius = this.radius - 4;
            inner = BiomeDictionary.getTypes((Biome)this.biome).contains(BiomeDictionary.Type.OCEAN) ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150348_b.func_176223_P();
            outer = Blocks.field_150348_b.func_176223_P();
        } else {
            innerRadius = this.radius - 1;
        }
        if (pos.func_177951_i((Vec3i)this.center) < (double)(innerRadius * innerRadius)) {
            return inner;
        }
        return outer;
    }

    public boolean hasVillage() {
        return this.village;
    }
}

