/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class SphereHelper {
    private static final long[] hashMultipliers;

    public static BlockPos limitBlockPosToChunk(BlockPos pos) {
        return new BlockPos(SphereHelper.inRange(pos.func_177958_n(), 0, 16), SphereHelper.inRange(pos.func_177956_o(), 0, 256), SphereHelper.inRange(pos.func_177952_p(), 0, 16));
    }

    public static BlockPos limitBlockPosTo(BlockPos original, BlockPos low, BlockPos high) {
        return new BlockPos(SphereHelper.inRange(original.func_177958_n(), low.func_177958_n(), high.func_177958_n()), SphereHelper.inRange(original.func_177956_o(), low.func_177956_o(), high.func_177956_o()), SphereHelper.inRange(original.func_177952_p(), low.func_177952_p(), high.func_177952_p()));
    }

    public static int inRange(int num, int lo, int hi) {
        if (num < lo) {
            return lo;
        }
        if (num >= hi) {
            return hi;
        }
        return num;
    }

    public static Iterator<BlockPos> iteratePositions(final BlockPos low, final BlockPos high) {
        return new Iterator<BlockPos>(){
            int x;
            int y;
            int z;
            BlockPos.MutableBlockPos pos;
            {
                this.x = low.func_177958_n();
                this.y = low.func_177956_o();
                this.z = low.func_177952_p();
                this.pos = new BlockPos.MutableBlockPos();
            }

            @Override
            public boolean hasNext() {
                return this.z < high.func_177952_p() && this.x < high.func_177958_n();
            }

            @Override
            public BlockPos next() {
                this.pos.func_181079_c(this.x, this.y, this.z);
                ++this.y;
                if (this.y >= high.func_177956_o()) {
                    this.y = low.func_177956_o();
                    ++this.x;
                }
                if (this.x >= high.func_177958_n()) {
                    this.x = low.func_177958_n();
                    ++this.z;
                }
                return this.pos;
            }
        };
    }

    public static long getRandomSeed(long worldSeed, ChunkPos pos) {
        return SphereHelper.hash(SphereHelper.hash(SphereHelper.hash(worldSeed) ^ (long)pos.field_77276_a) ^ (long)pos.field_77275_b);
    }

    public static long hash(long value) {
        long ret = 0L;
        for (int i = 0; i < 64; ++i) {
            ret += (value >> i & 1L) * hashMultipliers[i];
            ret *= hashMultipliers[i];
        }
        return ret;
    }

    public static int centered(Random rand, int max) {
        return rand.nextInt(max / 2 + 1) + rand.nextInt(max / 2 + (max & 1));
    }

    static {
        BufferedReader br = new BufferedReader(new InputStreamReader(SphereHelper.class.getResourceAsStream("hashvalues.txt")));
        hashMultipliers = br.lines().mapToLong(Long::parseLong).toArray();
    }
}

