/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.dimension;

import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.SphereHelper;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeProviderSphere
extends BiomeProvider {
    private final ISphereInfoProvider sphereInfo;
    private static final int BORDER_SIZE = 0;

    public BiomeProviderSphere(ISphereInfoProvider sphereInfo) {
        this.sphereInfo = sphereInfo;
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        Collection<Sphere> spheres = this.sphereInfo.getInfluencedSpheres(new ChunkPos(pos));
        return spheres.stream().filter(sphere -> {
            int r;
            int dZ;
            BlockPos center = sphere.getCenter();
            int dX = center.func_177958_n() - pos.func_177958_n();
            return dX * dX + (dZ = center.func_177952_p() - pos.func_177952_p()) * dZ < (r = sphere.getRadius() - 0) * r;
        }).max(Comparator.comparingInt(a -> a.getCenter().func_177956_o())).map(Sphere::getBiome).orElse(defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        return this.func_76931_a(biomes, x, z, width, height, false);
    }

    public Biome[] func_76931_a(@Nullable Biome[] biomes, int x, int z, int width, int height, boolean cacheFlag) {
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        Arrays.fill(biomes, Biomes.field_185440_P);
        ArrayList<Sphere> spheres = new ArrayList<Sphere>(this.sphereInfo.getInfluencedSpheres(new ChunkPos(x >> 4, z >> 4)));
        Collections.sort(spheres, Comparator.comparingInt(a -> a.getCenter().func_177956_o()));
        for (Sphere sphere : spheres) {
            BlockPos adjustedCenter = new BlockPos(sphere.getCenter().func_177958_n(), 0, sphere.getCenter().func_177952_p());
            int r = sphere.getRadius() - 0;
            Iterator<BlockPos> iter = SphereHelper.iteratePositions(new BlockPos(x, 0, z), new BlockPos(x + width, 0, z + height));
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (!(adjustedCenter.func_177951_i((Vec3i)pos) < (double)(r * r))) continue;
                int dX = pos.func_177958_n() - x;
                int dZ = pos.func_177952_p() - z;
                try {
                    biomes[dZ * width + dX] = sphere.getBiome();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
        }
        return biomes;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        return this.sphereInfo.getSphereStream(new ChunkPos(x, z), range).filter(sphere -> biomes.contains(sphere.getBiome())).map(Sphere::getCenter).findFirst().orElse(BlockPos.field_177992_a);
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        return allowed.stream().allMatch(BiomeProviderSphere::isBiomeOK);
    }

    public boolean func_190944_c() {
        return false;
    }

    public static boolean isBiomeOK(Biome biome) {
        return !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }
}

