/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.sphere.structures;

import aroma1997.world.DimensionalWorld;
import aroma1997.world.sphere.Sphere;
import aroma1997.world.sphere.sphereproviders.ISphereInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraftforge.common.BiomeManager;

public class MapGenStrongholdSphere
extends MapGenStronghold {
    private final ISphereInfoProvider sphereInfo;
    private final int spread = 3;
    private final double distance = 1000.0;
    private BlockPos[] poses;
    private final List<Biome> acceptedBiomes = new ArrayList<Biome>();

    public MapGenStrongholdSphere(ISphereInfoProvider info) {
        this.sphereInfo = info;
        LinkedHashSet<Biome> acceptedBiomes = new LinkedHashSet<Biome>();
        for (Biome b : Biome.field_185377_q) {
            if (BiomeManager.strongHoldBiomesBlackList.contains(b)) continue;
            acceptedBiomes.add(b);
        }
        acceptedBiomes.addAll(BiomeManager.strongHoldBiomes);
        this.acceptedBiomes.addAll(acceptedBiomes);
    }

    private void generatePositions() {
        this.poses = new BlockPos[128];
        int currentlyGenerated = 0;
        Random rand = new Random(this.field_75039_c.func_72905_C());
        BlockPos origin = this.field_75039_c.func_175694_M();
        double TWOPI = Math.PI * 2;
        int distance = 1;
        while (currentlyGenerated < this.poses.length) {
            double offset = rand.nextDouble() * (Math.PI * 2);
            for (int number = 0; number < 3 && currentlyGenerated < this.poses.length; ++number) {
                double totalAngleOffset = ((double)number * (Math.PI * 2) / 3.0 + offset) % (Math.PI * 2);
                BlockPos currentPos = origin.func_177963_a(Math.cos(totalAngleOffset) * (double)distance * this.distance, 0.0, Math.sin(totalAngleOffset) * (double)distance * this.distance);
                BiomeProvider biomeProvider = this.field_75039_c.func_72959_q();
                int n = currentPos.func_177958_n() >> 4;
                int n2 = currentPos.func_177952_p() >> 4;
                ((Object)((Object)this)).getClass();
                BlockPos pos = biomeProvider.func_180630_a(n, n2, 1000 / 16, this.field_151546_e, rand);
                if (pos == BlockPos.field_177992_a) continue;
                Collection<Sphere> spheres = this.sphereInfo.getInfluencedSpheres(new ChunkPos(pos));
                this.poses[currentlyGenerated++] = spheres.iterator().next().getCenter().func_177979_c(10);
            }
            ++distance;
        }
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        if (this.poses == null) {
            this.generatePositions();
        }
        double bestFound = 9.223372036854776E18;
        BlockPos bestFoundPos = null;
        for (BlockPos other : this.poses) {
            double distanceSq = other.func_177951_i((Vec3i)pos);
            if (!(distanceSq < bestFound)) continue;
            bestFound = distanceSq;
            bestFoundPos = other;
        }
        return bestFoundPos;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (this.poses == null) {
            this.generatePositions();
        }
        for (BlockPos pos : this.poses) {
            if (chunkX != pos.func_177958_n() >> 4 || chunkZ != pos.func_177952_p() >> 4) continue;
            return true;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        BlockPos center = this.func_180706_b(this.field_75039_c, new BlockPos(chunkX << 4, 32, chunkZ << 4), true);
        if (center == null) {
            DimensionalWorld.instance.log.error("Inconsistent Stronghold generation found at " + chunkX + " " + chunkZ);
            return new MapGenStronghold.Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
        MapGenStronghold.Start stronghold = new MapGenStronghold.Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        stronghold.func_186161_c().clear();
        StructureStrongholdPieces.PortalRoom room = new StructureStrongholdPieces.PortalRoom(0, this.field_75038_b, new StructureBoundingBox(new int[]{center.func_177958_n() - 5, center.func_177956_o() - 5, center.func_177952_p() - 10, center.func_177958_n() + 5, center.func_177956_o() - 1, center.func_177952_p() + 5}), EnumFacing.NORTH);
        stronghold.func_186161_c().add(room);
        return stronghold;
    }
}

