/*
 * Decompiled with CFR 0.152.
 */
package elucent.gravelores;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigManager {
    public static Configuration config;
    public static Set<String> blacklist;
    public static Map<String, Integer> weights;
    public static boolean hasBiomeWhitelist;
    public static boolean hasBiomeBlacklist;
    public static Set<String> biomeWhitelist;
    public static Set<String> biomeBlacklist;
    public static int orePileChance;
    public static int orePileMinSize;
    public static int orePileMaxSize;
    public static boolean oreFallingDropItems;
    public static String[] extraBlocks;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigManager.load();
        }
    }

    public static void load() {
        String[] biomeWhitearray;
        String[] biomeBlackarray;
        String[] blist;
        config.addCustomCategoryComment("ores", "Settings related to gravel ore generation.");
        for (String s : blist = config.getStringList("blacklist", "ores", new String[]{"oreDiamond", "oreLapis", "oreRedstone", "oreEmerald"}, "A list of blacklisted ore dictionary keys. Ores with these keys will not generate.")) {
            blacklist.add(s);
        }
        for (String s : biomeBlackarray = config.getStringList("biomeTypeBlacklist", "ores", new String[]{"OCEAN", "RIVER"}, "A list of biome types (for example, OCEAN or PLAINS) to not generate gravel ores in. Ignored if empty. See the Forge BiomeDictionary for valid names")) {
            biomeBlacklist.add(s.toUpperCase());
        }
        hasBiomeBlacklist = !biomeBlacklist.isEmpty();
        for (String s : biomeWhitearray = config.getStringList("biomeTypeWhitelist", "ores", new String[0], "A list of biome types (for example, OCEAN or PLAINS) to require to generate ores. Ignored if empty. See the Forge BiomeDictionary for valid names")) {
            biomeWhitelist.add(s.toUpperCase());
        }
        hasBiomeWhitelist = !biomeWhitelist.isEmpty();
        String[] spawnWeights = config.getStringList("spawnWeights", "ores", new String[]{"oreCoal:16", "oreIron:24", "oreRedstone:4", "oreGold:4", "oreLapis:2", "oreDiamond:1", "oreEmerald:1", "oreCopper:14", "oreTin:14", "oreLead:10", "oreSilver:8", "oreNickel:10", "oreAluminum:12"}, "The generation weight of each ore type. Ores like copper that may not exist in your instance, or blacklisted ores, will not be considered if not added by another mod. Follows the format \"<ore dictionary key>:<weight>\". If an ore is missing, it will default to 10.");
        for (int i = 0; i < spawnWeights.length; ++i) {
            String[] parts = spawnWeights[i].split(":");
            String oreKey = parts[0];
            int weight = Integer.valueOf(parts[1]);
            weights.put(oreKey, weight);
        }
        orePileChance = config.getInt("orePileChance", "ores", 20, 0, Short.MAX_VALUE, "Chance per chunk that an ore pile will spawn. Set this to zero to disable generation.");
        orePileMinSize = config.getInt("orePileMinSize", "ores", 10, 0, 100, "Minimum size value for generated ore piles. This is a number of block spawning attempts, not blocks -- piles can be smaller than this minimum value.");
        orePileMaxSize = config.getInt("orePileMaxSize", "ores", 40, 0, 100, "Maximum size value for generated ore piles. This is a number of block spawning attempts, not blocks -- piles will not always be between this and the minimum size in block count.");
        oreFallingDropItems = config.getBoolean("oreFallingDropItems", "ores", false, "If true, falling gravel ores drop items if they are unable to land (e.g. falls on a torch). Defaults to false which prevents working around harvest levels.");
        extraBlocks = config.getStringList("extraBlocks", "ores", new String[0], "Additional gravel ores to add. Should be in the format of 'oreName:color:miningLevel:hardness' or 'oreName:color:miningLevel:hardness:modid:baseore:meta'. You will need to provide localizations in the form of 'tile.extra_gravel_ore.oreName.name', but they will automatically be oredicted with a prefix of 'ore'");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("gravelores")) {
            ConfigManager.load();
        }
    }

    static {
        blacklist = new HashSet<String>();
        weights = new HashMap<String, Integer>();
        hasBiomeWhitelist = false;
        hasBiomeBlacklist = false;
        biomeWhitelist = new HashSet<String>();
        biomeBlacklist = new HashSet<String>();
        orePileChance = 20;
        orePileMinSize = 10;
        orePileMaxSize = 40;
        oreFallingDropItems = false;
        extraBlocks = new String[0];
    }
}

