/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.portal.info;

import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import me.ichun.mods.portalgun.common.tileentity.TilePortalBase;
import me.ichun.mods.portalgun.common.tileentity.TilePortalMaster;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class PortalInfo {
    public String uuid;
    public String channelName;
    public boolean isTypeA;
    public int colour = 0xFFFFFF;
    private BlockPos pos = new BlockPos(-1, -1, -1);
    private PortalInfo pair;

    public PortalInfo setInfo(String uuid, String channelName, boolean isTypeA) {
        this.uuid = uuid;
        this.channelName = channelName;
        this.isTypeA = isTypeA;
        return this;
    }

    public PortalInfo setColour(int i) {
        this.colour = i;
        return this;
    }

    public PortalInfo setPos(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        return this;
    }

    public PortalInfo setPos(BlockPos pos) {
        this.pos = new BlockPos((Vec3i)pos);
        return this;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPair(PortalInfo pair) {
        this.pair = pair;
    }

    public PortalInfo getPair() {
        return this.pair;
    }

    public TilePortalMaster getTileEntity(World world) {
        TileEntity te;
        if (this.pos.func_177956_o() >= 0 && (te = world.func_175625_s(this.pos)) instanceof TilePortalMaster) {
            return (TilePortalMaster)te;
        }
        return null;
    }

    public PortalPlacement getPortalPlacement(World world) {
        TileEntity te;
        if (this.pos.func_177956_o() >= 0 && (te = world.func_175625_s(this.pos)) instanceof TilePortalBase) {
            PortalPlacement pp = ((TilePortalBase)te).getPortalPlacementFromInfo(this);
            if (pp != null && pp.world == null) {
                pp.setWorld(world);
            }
            return pp;
        }
        return null;
    }

    public PortalInfo readFromNBT(NBTTagCompound tag) {
        this.uuid = tag.func_74779_i("uuid");
        this.channelName = tag.func_74779_i("channelName");
        this.isTypeA = tag.func_74767_n("isTypeA");
        this.colour = tag.func_74762_e("colour");
        this.setPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("uuid", this.uuid);
        tag.func_74778_a("channelName", this.channelName);
        tag.func_74757_a("isTypeA", this.isTypeA);
        tag.func_74768_a("colour", this.colour);
        tag.func_74768_a("x", this.pos.func_177958_n());
        tag.func_74768_a("y", this.pos.func_177956_o());
        tag.func_74768_a("z", this.pos.func_177952_p());
        return tag;
    }

    public boolean isPair(PortalInfo info) {
        return info.uuid.equals(this.uuid) && info.channelName.equals(this.channelName) && info.isTypeA != this.isTypeA;
    }

    public boolean isSameType(PortalInfo info) {
        return info.uuid.equals(this.uuid) && info.channelName.equals(this.channelName) && info.isTypeA == this.isTypeA;
    }

    public boolean equals(Object o) {
        if (o instanceof PortalInfo) {
            PortalInfo info = (PortalInfo)o;
            return info.uuid.equals(this.uuid) && info.channelName.equals(this.channelName) && info.isTypeA == this.isTypeA && info.pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return (this.uuid + "_" + this.channelName + "_" + (this.isTypeA ? "A" : "B")).hashCode();
    }
}

