/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block;

import com.meteor.extrabotany.common.block.BlockMod;
import com.meteor.extrabotany.common.block.tile.TileGildedTinyPotato;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class BlockGildedTinyPotato
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
    private static final String TAG_HUNGER = "hunger";
    private static final String TAG_LOVE = "love";
    private static final String TAG_ISTOUCHED = "istouched";

    public BlockGildedTinyPotato() {
        super(Material.field_151590_u, "gildedtinypotato");
        this.func_149711_c(0.45f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.SOUTH));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BotaniaStateProps.CARDINALS)) {
            case NORTH: {
                return 0;
            }
            case WEST: {
                return 3;
            }
            case EAST: {
                return 1;
            }
        }
        return 2;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing side;
        switch (meta) {
            case 3: {
                side = EnumFacing.WEST;
                break;
            }
            case 0: {
                side = EnumFacing.NORTH;
                break;
            }
            case 1: {
                side = EnumFacing.EAST;
                break;
            }
            default: {
                side = EnumFacing.SOUTH;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)side);
    }

    public LexiconEntry getEntry(World arg0, BlockPos arg1, EntityPlayer arg2, ItemStack arg3) {
        return null;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGildedTinyPotato) {
            ((TileGildedTinyPotato)tile).touch();
            ((TileGildedTinyPotato)tile).eat(player.func_184586_b(hand));
            world.func_175688_a(EnumParticleTypes.HEART, (double)pos.func_177958_n() + BlockGildedTinyPotato.AABB.field_72340_a + Math.random() * (BlockGildedTinyPotato.AABB.field_72336_d - BlockGildedTinyPotato.AABB.field_72340_a), (double)pos.func_177956_o() + BlockGildedTinyPotato.AABB.field_72337_e, (double)pos.func_177952_p() + BlockGildedTinyPotato.AABB.field_72339_c + Math.random() * (BlockGildedTinyPotato.AABB.field_72334_f - BlockGildedTinyPotato.AABB.field_72339_c), 0.0, 0.0, 0.0, new int[0]);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)entityLiving.func_174811_aO().func_176734_d()));
        if (stack.func_82837_s()) {
            ((TileGildedTinyPotato)world.func_175625_s((BlockPos)pos)).name = stack.func_82833_r();
        }
        ((TileGildedTinyPotato)world.func_175625_s((BlockPos)pos)).love = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_LOVE, (int)0);
        ((TileGildedTinyPotato)world.func_175625_s((BlockPos)pos)).hunger = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_HUNGER, (int)0);
        ((TileGildedTinyPotato)world.func_175625_s((BlockPos)pos)).touchTicks = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_ISTOUCHED, (int)0);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this);
            String name = ((TileGildedTinyPotato)tile).name;
            if (!name.isEmpty()) {
                stack.func_151001_c(name);
            }
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_LOVE, (int)((TileGildedTinyPotato)tile).love);
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_HUNGER, (int)((TileGildedTinyPotato)tile).hunger);
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_ISTOUCHED, (int)((TileGildedTinyPotato)tile).touchTicks);
            list.add((Object)stack);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileGildedTinyPotato();
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }
}

