/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.subtile.functional;

import com.meteor.extrabotany.common.block.tile.TilePedestal;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.item.ItemFriedChicken;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;

public class SubTileAnnoyingFlower
extends SubTileFunctional {
    private static final int COST = ConfigHandler.ANNOYINGFLOWER_COST;
    private static final int RANGE = 3;
    private static final int[][] OFFSETS = new int[][]{{0, 1}, {0, -1}, {1, 0}, {-1, 0}, {-1, 1}, {-1, -1}, {1, 1}, {1, -1}};
    private static final String TAG_TIME = "times";
    int times;

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_TIME, this.times);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.times = cmp.func_74762_e(TAG_TIME);
    }

    public void onUpdate() {
        int cd;
        super.onUpdate();
        if (this.redstoneSignal > 0) {
            return;
        }
        boolean hasWater = false;
        for (int x = -4; x < 4; ++x) {
            for (int z = -4; z < 4; ++z) {
                TilePedestal te;
                Item i;
                BlockPos posi = new BlockPos((Vec3i)this.supertile.func_174877_v().func_177982_a(x, 0, z));
                if (!(this.supertile.func_145831_w().func_175625_s(posi) instanceof TilePedestal) || (i = (te = (TilePedestal)this.supertile.func_145831_w().func_175625_s(posi)).getItem().func_77973_b()) == null || i != Items.field_151131_as) continue;
                hasWater = true;
            }
        }
        for (EntityItem item : this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-3, -3, -3), this.supertile.func_174877_v().func_177982_a(4, 4, 4)))) {
            if (!(item.func_92059_d().func_77973_b() instanceof ItemFriedChicken) || item.func_92059_d().func_190916_E() <= 0) continue;
            item.func_92059_d().func_190918_g(1);
            this.times += ConfigHandler.TIMES;
        }
        int n = cd = this.times > 0 ? ConfigHandler.TICKS * 2 / 5 : ConfigHandler.TICKS;
        if (this.redstoneSignal == 0 && this.ticksExisted % cd == 0 && this.mana >= COST && hasWater && !this.getWorld().field_72995_K) {
            ItemStack stack;
            Random rand = this.supertile.func_145831_w().field_73012_v;
            do {
                LootContext.Builder lootcontext$builder;
                if (this.times > 0) {
                    lootcontext$builder = new LootContext.Builder((WorldServer)this.getWorld());
                    List rares = this.supertile.func_145831_w().func_184146_ak().func_186521_a(LootTableList.field_186389_an).func_186462_a(rand, lootcontext$builder.func_186471_a());
                    stack = (ItemStack)rares.get(rand.nextInt(rares.size()));
                    --this.times;
                    continue;
                }
                lootcontext$builder = new LootContext.Builder((WorldServer)this.getWorld());
                List items = this.supertile.func_145831_w().func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(rand, lootcontext$builder.func_186471_a());
                stack = (ItemStack)items.get(rand.nextInt(items.size()));
            } while (stack == null);
            int bound = 7;
            EntityItem entity = new EntityItem(this.supertile.func_145831_w(), (double)(this.supertile.func_174877_v().func_177958_n() - 3 + rand.nextInt(bound)), (double)(this.supertile.func_174877_v().func_177956_o() + 2), (double)(this.supertile.func_174877_v().func_177952_p() - 3 + rand.nextInt(bound)), stack);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            if (!this.supertile.func_145831_w().field_72995_K) {
                this.supertile.func_145831_w().func_72838_d((Entity)entity);
            }
            this.mana -= COST;
            this.sync();
        }
    }

    public int getColor() {
        return 0;
    }

    public int getMaxMana() {
        return 1000;
    }

    public LexiconEntry getEntry() {
        return LexiconData.annoyingflower;
    }

    public boolean acceptsRedstone() {
        return true;
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 3);
    }
}

