/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.subtile.generating;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.subtile.SubTileGeneratingNature;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;

public class SubTileTinkle
extends SubTileGeneratingNature {
    private static final int RANGE = 8;
    private static final String TAG_TIME = "time";
    private int time = 0;

    public LexiconEntry getEntry() {
        return LexiconData.tinkle;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.redstoneSignal > 0) {
            return;
        }
        super.onUpdate();
        World world = this.supertile.func_145831_w();
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L) {
            int time;
            NBTTagCompound tag = this.supertile.getTileData();
            int prevTime = time = tag.func_74771_c(TAG_TIME);
            for (EntityPlayer player : this.supertile.func_145831_w().func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-8, -8, -8), this.supertile.func_174877_v().func_177982_a(9, 9, 9)))) {
                int buff;
                double vx = player.field_70165_t - player.field_71094_bP;
                double vy = player.field_70163_u - player.field_71095_bQ;
                double vz = player.field_70161_v - player.field_71085_bR;
                double vel = Math.sqrt(vx * vx + vy * vy + vz * vz);
                if (player.func_70644_a(MobEffects.field_76424_c)) {
                    vel *= 1.2;
                }
                int limit = 10;
                int n = ConfigHandler.LP_BELLFLOWER ? (this.isEnabled() ? 15 : 0) : (buff = 0);
                if ((time += MathHelper.func_76125_a((int)((int)(vel * 10.0)), (int)0, (int)8)) >= 10) {
                    if (this.mana < this.getMaxMana()) {
                        this.mana += Math.min(ConfigHandler.EFF_TINKLE + buff, this.getMaxMana() - this.mana);
                    }
                    ExtraBotanyAPI.unlockAdvancement(player, "tinkleUse");
                    player.func_71020_j(0.02f);
                    time %= 10;
                }
                if (time == prevTime) continue;
                tag.func_74774_a(TAG_TIME, (byte)time);
            }
        }
    }

    @Override
    public int getRate() {
        return 8;
    }

    @Override
    public boolean willConsume() {
        return true;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_TIME, this.time);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.time = cmp.func_74762_e(TAG_TIME);
    }

    public int getMaxMana() {
        return 1000;
    }

    public int getDelayBetweenPassiveGeneration() {
        return 2;
    }

    public int getColor() {
        return 0xCCFF00;
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 8);
    }
}

