/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import com.google.common.base.Predicates;
import com.meteor.extrabotany.common.block.fluid.ModFluid;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class TileManaLiquefaction
extends TileMod
implements ITickable,
IManaReceiver,
ISparkAttachable {
    private static final String TAG_MANA = "mana";
    private static final String TAG_ENERGY = "energy";
    int mana;
    public int energy = 0;
    private static final int MAX_ENERGY = 16000;

    public void func_73660_a() {
        if (!ConfigHandler.DISABLE_MANALIQUEFICATION) {
            return;
        }
        int redstoneSignal = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.func_145831_w().func_175651_c(this.func_174877_v().func_177972_a(dir), dir);
            redstoneSignal = Math.max(redstoneSignal, redstoneSide);
        }
        for (EnumFacing e : EnumFacing.field_82609_l) {
            TileEntity te;
            BlockPos neighbor = this.func_174877_v().func_177972_a(e);
            if (!this.field_145850_b.func_175667_e(neighbor) || (te = this.field_145850_b.func_175625_s(neighbor)) == null) continue;
            IFluidHandler storage = null;
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, e.func_176734_d())) {
                storage = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, e.func_176734_d());
            } else if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                storage = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            }
            if (storage != null) {
                if (redstoneSignal == 0) {
                    if (!this.isFull() && storage.drain(new FluidStack(ModFluid.fluidMana, 1), true) != null) {
                        ++this.energy;
                    }
                } else if (this.energy >= 25) {
                    this.energy -= storage.fill(new FluidStack(ModFluid.fluidMana, 25), true);
                }
            }
            int speed = ConfigHandler.MG_TRANSFERSPEED;
            if (!(te instanceof TileSpreader) || redstoneSignal != 0) continue;
            TileSpreader p = (TileSpreader)te;
            if (this.getCurrentMana() < speed || p.getCurrentMana() >= p.getMaxMana()) continue;
            int current = Math.min(speed, p.getMaxMana() - p.getCurrentMana());
            p.recieveMana(current);
            this.recieveMana(-current);
        }
        if (redstoneSignal == 0) {
            if (this.energy > 0 && this.getCurrentMana() <= 998000) {
                this.recieveMana(2000);
                this.energy -= 2;
            }
        } else if (this.getCurrentMana() >= 2000) {
            this.recieveMana(-2000);
            this.energy += 2;
        }
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public boolean isFull() {
        return this.mana >= 1000000;
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(1000000, this.mana + mana);
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a(TAG_ENERGY, this.energy);
    }

    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.energy = cmp.func_74762_e(TAG_ENERGY);
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public void attachSpark(ISparkEntity arg0) {
    }

    public boolean canAttachSpark(ItemStack arg0) {
        return true;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        int space = Math.max(0, 1000000 - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        return 0;
    }
}

