/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.core.handler;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.meteor.extrabotany.api.item.IDarkElfSpawner;
import com.meteor.extrabotany.common.entity.EntityDarkPixie;
import com.meteor.extrabotany.common.item.ModItems;
import com.meteor.extrabotany.common.item.equipment.armor.shadowwarrior.ItemShadowWarriorHelm;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.common.core.helper.PlayerHelper;

@Mod.EventBusSubscriber(modid="extrabotany")
public final class DarkPixieHandler {
    private static final Potion[] potions = new Potion[]{MobEffects.field_76440_q, MobEffects.field_82731_v, MobEffects.field_76421_d, MobEffects.field_76437_t, MobEffects.field_76438_s};

    private DarkPixieHandler() {
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = PlayerHelper.getFirstHeldItemClass((EntityPlayer)player, IDarkElfSpawner.class);
            float chance = DarkPixieHandler.getChance(stack);
            for (ItemStack element : player.field_71071_by.field_70460_b) {
                chance += DarkPixieHandler.getChance(element);
            }
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                chance += DarkPixieHandler.getChance(baubles.getStackInSlot(i));
            }
            if (Math.random() < (double)chance) {
                EntityDarkPixie pixie = DarkPixieHandler.getPixie(player, (EntityLivingBase)event.getSource().func_76346_g(), stack);
                player.field_70170_p.func_72838_d((Entity)pixie);
            }
        }
    }

    public static EntityDarkPixie getPixie(EntityPlayer player, EntityLivingBase target, ItemStack stack) {
        EntityDarkPixie pixie = new EntityDarkPixie(player.field_70170_p);
        pixie.func_70107_b(player.field_70165_t, player.field_70163_u + 3.0, player.field_70161_v);
        if (((ItemShadowWarriorHelm)ModItems.swhelm).hasArmorSet(player)) {
            pixie.setApplyPotionEffect(new PotionEffect(potions[player.func_130014_f_().field_73012_v.nextInt(potions.length)], 40, 0));
        }
        float dmg = 2.0f;
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.shadowkatana) {
            dmg += 2.0f;
        }
        if (!pixie.func_130014_f_().func_72935_r()) {
            dmg *= 2.0f;
        }
        pixie.setProps(target, (EntityLivingBase)player, 0, dmg);
        pixie.func_180482_a(player.field_70170_p.func_175649_E(new BlockPos((Entity)pixie)), null);
        return pixie;
    }

    private static float getChance(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDarkElfSpawner)) {
            return 0.0f;
        }
        return ((IDarkElfSpawner)stack.func_77973_b()).getSpawnChance(stack);
    }
}

