/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.core.network;

import com.meteor.extrabotany.common.core.network.AbstractPacket;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkWrapper {
    public final SimpleNetworkWrapper network;
    protected final AbstactPacketHandler handler;
    private int id = 0;

    public NetworkWrapper(String channelName) {
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(channelName);
        this.handler = new AbstactPacketHandler();
    }

    public void registerPacket(Class<? extends AbstractPacket> packetClazz) {
        this.registerPacketClient(packetClazz);
        this.registerPacketServer(packetClazz);
    }

    public void registerPacketClient(Class<? extends AbstractPacket> packetClazz) {
        this.registerPacketImpl(packetClazz, Side.CLIENT);
    }

    public void registerPacketServer(Class<? extends AbstractPacket> packetClazz) {
        this.registerPacketImpl(packetClazz, Side.SERVER);
    }

    private void registerPacketImpl(Class<? extends AbstractPacket> packetClazz, Side side) {
        this.network.registerMessage((IMessageHandler)this.handler, packetClazz, this.id++, side);
    }

    public static class AbstactPacketHandler
    implements IMessageHandler<AbstractPacket, IMessage> {
        public IMessage onMessage(AbstractPacket packet, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                return packet.handleServer(ctx.getServerHandler());
            }
            return packet.handleClient(ctx.getClientHandler());
        }
    }
}

