/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity;

import com.meteor.extrabotany.common.entity.EntityThrowableCopy;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.common.Botania;

public class EntityMagicArrow
extends EntityThrowableCopy {
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_LIFE = "life";
    private static final String TAG_ROTATION = "rotation";
    private static final DataParameter<Integer> DAMAGE = EntityDataManager.func_187226_a(EntityMagicArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(EntityMagicArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityMagicArrow.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityMagicArrow(World worldIn) {
        super(worldIn);
    }

    public EntityMagicArrow(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187214_a(DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase thrower = this.getThrower();
        if (!(this.field_70170_p.field_72995_K || thrower != null && thrower instanceof EntityPlayer && !thrower.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        EntityPlayer player = (EntityPlayer)thrower;
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 2.0, this.field_70163_u - 2.0, this.field_70161_v - 2.0, this.field_70142_S + 2.0, this.field_70137_T + 2.0, this.field_70136_U + 2.0);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase living : entities) {
                if (living == thrower) continue;
                double attribute = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                if (living.field_70737_aN != 0) continue;
                EntityMagicArrow.attackedFrom(living, player, (int)((double)this.getDamage() + attribute * (double)0.8f));
            }
        }
        super.func_70071_h_();
        Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1f, 0.85f, 0.1f, 0.2f, 0.0f);
        if (this.field_70173_aa > this.getLife()) {
            this.func_70106_y();
        }
    }

    public static void attackedFrom(EntityLivingBase target, EntityPlayer player, int i) {
        if (player != null) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)i);
        } else {
            target.func_70097_a(DamageSource.field_76377_j, (float)i);
        }
    }

    @Override
    protected void onImpact(RayTraceResult pos) {
        EntityLivingBase thrower = this.getThrower();
        if (pos.field_72308_g == null || pos.field_72308_g != thrower) {
            // empty if block
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74768_a(TAG_LIFE, this.getLife());
        cmp.func_74768_a(TAG_DAMAGE, this.getDamage());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setLife(cmp.func_74762_e(TAG_LIFE));
        this.setDamage(cmp.func_74762_e(TAG_DAMAGE));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int delay) {
        this.field_70180_af.func_187227_b(LIFE, (Object)delay);
    }

    public int getDamage() {
        return (Integer)this.field_70180_af.func_187225_a(DAMAGE);
    }

    public void setDamage(int delay) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)delay);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }
}

