/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.gaia;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.entity.IBossProjectile;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.core.handler.StatHandler;
import com.meteor.extrabotany.common.entity.EntityThrowableCopy;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.Vector3;

public class EntitySkullMissile
extends EntityThrowableCopy
implements IBossProjectile {
    int time = 0;
    double lockX;
    double lockY = -1.0;
    double lockZ;
    private static final String TAG_FIRE = "fire";
    private static final String TAG_EFFECT = "effect";
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_TRUEDAMAGE = "truedamage";
    private static final String TAG_TIME = "time";
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntitySkullMissile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TRUEDAMAGE = EntityDataManager.func_187226_a(EntitySkullMissile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> EFFECT = EntityDataManager.func_187226_a(EntitySkullMissile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FIRE = EntityDataManager.func_187226_a(EntitySkullMissile.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(EntitySkullMissile.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySkullMissile(World world) {
        super(world);
    }

    public EntitySkullMissile(EntityLivingBase thrower) {
        super(thrower.field_70170_p);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TRUEDAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EFFECT, (Object)false);
        this.field_70180_af.func_187214_a(FIRE, (Object)false);
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74768_a(TAG_TIME, this.time);
        cmp.func_74776_a(TAG_DAMAGE, this.getDamage());
        cmp.func_74776_a(TAG_TRUEDAMAGE, this.getTrueDamage());
        cmp.func_74757_a(TAG_EFFECT, this.getEffect());
        cmp.func_74757_a(TAG_FIRE, this.getFire());
    }

    @Override
    public void func_70037_a(NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.time = cmp.func_74762_e(TAG_TIME);
        this.setDamage(cmp.func_74760_g(TAG_DAMAGE));
        this.setTrueDamage(cmp.func_74760_g(TAG_TRUEDAMAGE));
        this.setFire(cmp.func_74767_n(TAG_FIRE));
        this.setEffect(cmp.func_74767_n(TAG_EFFECT));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float dam) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(dam));
    }

    public float getTrueDamage() {
        return ((Float)this.field_70180_af.func_187225_a(TRUEDAMAGE)).floatValue();
    }

    public void setTrueDamage(float dam) {
        this.field_70180_af.func_187227_b(TRUEDAMAGE, (Object)Float.valueOf(dam));
    }

    public void setFire(boolean b) {
        this.field_70180_af.func_187227_b(FIRE, (Object)b);
    }

    public void setEffect(boolean b) {
        this.field_70180_af.func_187227_b(EFFECT, (Object)b);
    }

    public boolean getFire() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRE);
    }

    public boolean getEffect() {
        return (Boolean)this.field_70180_af.func_187225_a(EFFECT);
    }

    public void setTarget(EntityPlayer e) {
        this.field_70180_af.func_187227_b(TARGET, (Object)(e == null ? -1 : e.func_145782_y()));
    }

    public EntityPlayer getTargetEntity() {
        int id = (Integer)this.field_70180_af.func_187225_a(TARGET);
        Entity e = this.field_70170_p.func_73045_a(id);
        if (e != null && e instanceof EntityPlayer) {
            return (EntityPlayer)e;
        }
        return null;
    }

    @Override
    public void func_70071_h_() {
        double lastTickPosX = this.field_70142_S;
        double lastTickPosY = this.field_70137_T;
        double lastTickPosZ = this.field_70136_U;
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.findTarget() && this.time <= 100)) {
            this.func_70106_y();
            return;
        }
        Vector3 thisVec = Vector3.fromEntityCenter((Entity)this);
        Vector3 oldPos = new Vector3(lastTickPosX, lastTickPosY, lastTickPosZ);
        Vector3 diff = thisVec.subtract(oldPos);
        Vector3 step = diff.normalize().multiply(0.05);
        int steps = (int)(diff.mag() / step.mag());
        Vector3 particlePos = oldPos;
        Botania.proxy.setSparkleFXCorrupt(true);
        for (int i = 0; i < steps; ++i) {
            Botania.proxy.sparkleFX(particlePos.x, particlePos.y, particlePos.z, 1.0f, 0.0f, 1.0f, 0.8f, 2);
            if (this.field_70170_p.field_73012_v.nextInt(steps) <= 1) {
                Botania.proxy.sparkleFX(particlePos.x + (Math.random() - 0.5) * 0.4, particlePos.y + (Math.random() - 0.5) * 0.4, particlePos.z + (Math.random() - 0.5) * 0.4, 1.0f, 0.0f, 1.0f, 0.8f, 2);
            }
            particlePos = particlePos.add(step);
        }
        Botania.proxy.setSparkleFXCorrupt(false);
        EntityPlayer target = this.getTargetEntity();
        if (target != null) {
            if (this.lockY == -1.0) {
                this.lockX = target.field_70165_t;
                this.lockY = target.field_70163_u;
                this.lockZ = target.field_70161_v;
            }
            Vector3 targetVec = new Vector3(this.lockX, this.lockY, this.lockZ);
            Vector3 diffVec = targetVec.subtract(thisVec);
            Vector3 motionVec = diffVec.normalize().multiply(0.6);
            this.field_70159_w = motionVec.x;
            this.field_70181_x = motionVec.y;
            if (this.time < 10) {
                this.field_70181_x = Math.abs(this.field_70181_x);
            }
            this.field_70179_y = motionVec.z;
            List targetList = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - 1.0, this.field_70161_v - 1.0, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0));
            if (targetList.contains(target)) {
                float amplifier = StatHandler.hasStat(target, "gaiaDefeat") ? 1.0f : 0.7f;
                target.func_70097_a(DamageSource.field_76377_j, this.getDamage() * amplifier);
                target.func_70097_a(DamageSource.field_76377_j.func_76348_h().func_151518_m(), 0.5f);
                ExtraBotanyAPI.dealTrueDamage(this.getThrower(), (EntityLivingBase)target, this.getTrueDamage() * amplifier);
                if (this.getFire()) {
                    target.func_70015_d(5);
                }
                if (this.getEffect()) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 1));
                }
                float m = 0.35f;
                for (int i = 0; i < (int)(5.0 * ConfigHandler.PARTICLE); ++i) {
                    Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.5f, (float)(Math.random() - 0.5) * m, (float)(Math.random() - 0.5) * m, (float)(Math.random() - 0.5) * m);
                }
                this.func_70106_y();
            }
        }
        ++this.time;
    }

    private List<EntityPlayer> getPlayersAround() {
        BlockPos source = this.func_180425_c();
        float range = 15.0f;
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
    }

    public boolean findTarget() {
        EntityPlayer target = this.getTargetEntity();
        if (target != null && target.func_110143_aJ() > 0.0f && !target.field_70128_L && this.field_70170_p.field_72996_f.contains(target)) {
            return true;
        }
        if (target != null) {
            this.setTarget(null);
        }
        double range = 15.0;
        AxisAlignedBB bounds = new AxisAlignedBB(this.field_70165_t - range, this.field_70163_u - range, this.field_70161_v - range, this.field_70165_t + range, this.field_70163_u + range, this.field_70161_v + range);
        List entities = this.field_70170_p.func_72872_a(EntityPlayer.class, bounds);
        while (entities.size() > 0) {
            Entity e = (Entity)entities.get(this.field_70170_p.field_73012_v.nextInt(entities.size()));
            if (!(e instanceof EntityLivingBase) || e.field_70128_L) {
                entities.remove(e);
                continue;
            }
            target = (EntityPlayer)e;
            this.setTarget(target);
            break;
        }
        return target != null;
    }

    @Override
    protected void onImpact(@Nonnull RayTraceResult pos) {
        switch (pos.field_72313_a) {
            case BLOCK: {
                Block block = this.field_70170_p.func_180495_p(pos.func_178782_a()).func_177230_c();
                if (block instanceof BlockBush || block instanceof BlockLeaves) {
                    return;
                }
                this.func_70106_y();
                break;
            }
            case ENTITY: {
                if (pos.field_72308_g != this.getTargetEntity()) break;
                this.func_70106_y();
                break;
            }
            default: {
                this.func_70106_y();
            }
        }
    }

    @Override
    public boolean isBoss(Entity p) {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }
}

