/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.gaia;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.entity.IBossProjectile;
import com.meteor.extrabotany.common.entity.EntityThrowableCopy;
import com.meteor.extrabotany.common.entity.gaia.EntityVoidHerrscher;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;

public class EntitySubspaceLance
extends EntityThrowableCopy
implements IBossProjectile {
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_LIFE = "life";
    private static final String TAG_PITCH = "pitch";
    private static final String TAG_LIGHTNING_SEED = "lightningSeed";
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntitySubspaceLance.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DAMAGE = EntityDataManager.func_187226_a(EntitySubspaceLance.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(EntitySubspaceLance.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> PITCH = EntityDataManager.func_187226_a(EntitySubspaceLance.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SEED = EntityDataManager.func_187226_a(EntitySubspaceLance.class, (DataSerializer)DataSerializers.field_187193_c);
    private Status preStatus;
    private Status status;

    public EntitySubspaceLance(World worldIn) {
        super(worldIn);
    }

    public EntitySubspaceLance(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.15f;
    }

    @Override
    public void func_70071_h_() {
        this.preStatus = this.status;
        if (this.status != Status.STANDBY) {
            this.func_70634_a(this.field_70165_t, this.field_70163_u - (double)0.15f, this.field_70161_v);
            this.status = this.getStatus();
        } else {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70071_h_();
        if (this.field_70173_aa > this.getLife()) {
            this.func_70106_y();
        }
        EntityLivingBase thrower = this.getThrower();
        if (!this.field_70170_p.field_72995_K && (thrower == null || thrower.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 1.5, this.field_70163_u - 2.0, this.field_70161_v - 1.5, this.field_70142_S + 1.5, this.field_70137_T + 2.0, this.field_70136_U + 1.5);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
        for (EntityLivingBase living : entities) {
            if (living == thrower || living.field_70737_aN != 0 || this.field_70173_aa % 35 != 0 || !(living.func_110143_aJ() > 20.0f) || this.field_70170_p.field_72995_K || !living.func_70089_S()) continue;
            this.lightning(living);
        }
        List lances = this.field_70170_p.func_72872_a(EntitySubspaceLance.class, new AxisAlignedBB(this.field_70165_t - 15.0, this.field_70163_u - 15.0, this.field_70161_v - 15.0, this.field_70142_S + 15.0, this.field_70137_T + 15.0, this.field_70136_U + 15.0));
        for (EntitySubspaceLance lance : lances) {
            float distance = MathHelper.pointDistanceSpace((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)lance.field_70165_t, (double)lance.field_70163_u, (double)lance.field_70161_v);
            Vec3d oldPosVec = new Vec3d(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 1.5, this.field_70161_v);
            Vec3d newPosVec = new Vec3d(lance.field_70165_t, lance.field_70163_u + (double)(this.field_70131_O / 2.0f) + 1.5, lance.field_70161_v);
            for (EntityPlayer player : this.getPlayersAround()) {
                RayTraceResult rtr = player.func_174813_aQ().func_186662_g(0.4).func_72327_a(oldPosVec, newPosVec);
                if (rtr == null || this.field_70173_aa % 5 != 0 || !(player.func_110143_aJ() > 8.0f)) continue;
                player.func_70097_a(DamageSource.field_76377_j.func_76348_h().func_151518_m(), 1.2f);
                player.func_70097_a(DamageSource.field_180137_b.func_76348_h().func_151518_m(), 1.2f);
                ExtraBotanyAPI.dealTrueDamage(this.getThrower(), (EntityLivingBase)player, 0.4f);
                player.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 100, 1));
            }
            int i = 0;
            while ((float)i < distance) {
                float x = (float)(this.field_70165_t + (lance.field_70165_t - this.field_70165_t) * (double)i / (double)distance) + 0.5f;
                float y = (float)(this.field_70163_u + (lance.field_70163_u - this.field_70163_u) * (double)i / (double)distance) + 2.2f;
                float z = (float)(this.field_70161_v + (lance.field_70161_v - this.field_70161_v) * (double)i / (double)distance) + 0.5f;
                Botania.proxy.sparkleFX((double)x, (double)y, (double)z, 0.1f, 0.0f, 1.0f, 1.2f, 5);
                ++i;
            }
        }
    }

    public void lightning(EntityLivingBase entity) {
        double range = 8.0;
        ArrayList<EntityLivingBase> alreadyTargetedEntities = new ArrayList<EntityLivingBase>();
        int dmg = 4;
        Predicate<Entity> selector = e -> e instanceof EntityLivingBase && !alreadyTargetedEntities.contains(e);
        Random rand = new Random();
        EntityLivingBase lightningSource = entity;
        if (lightningSource == null) {
            return;
        }
        int hops = entity.field_70170_p.func_72911_I() ? 10 : 4;
        for (int i = 0; i < hops; ++i) {
            List entities = entity.field_70170_p.func_175674_a((Entity)lightningSource, new AxisAlignedBB(lightningSource.field_70165_t - range, lightningSource.field_70163_u - range, lightningSource.field_70161_v - range, lightningSource.field_70165_t + range, lightningSource.field_70163_u + range, lightningSource.field_70161_v + range), selector::test);
            if (entities.isEmpty()) break;
            EntityLivingBase target = (EntityLivingBase)entities.get(rand.nextInt(entities.size()));
            if (!(target instanceof EntityVoidHerrscher)) {
                if (target.func_110143_aJ() > 10.0f) {
                    ExtraBotanyAPI.dealTrueDamage(this.getThrower(), target, (float)dmg + target.func_110138_aP() * 0.1f);
                }
                target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 1));
            }
            Botania.proxy.lightningFX(Vector3.fromEntityCenter((Entity)lightningSource), Vector3.fromEntityCenter((Entity)target), 1.0f, 96708, 0xAADFFF);
            alreadyTargetedEntities.add(target);
            lightningSource = target;
            --dmg;
        }
    }

    public List<EntityPlayer> getPlayersAround() {
        BlockPos source = this.func_180425_c();
        float range = 24.0f;
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
    }

    public static void attackedFrom(EntityLivingBase target, EntityLivingBase player, int i) {
        if (player != null && player instanceof EntityPlayer) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), (float)i);
        } else {
            target.func_70097_a(DamageSource.field_76377_j, (float)i);
        }
    }

    @Override
    protected void onImpact(RayTraceResult pos) {
        EntityLivingBase thrower = this.getThrower();
        if (pos.field_72308_g == null || pos.field_72308_g != thrower) {
            // empty if block
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
        cmp.func_74768_a(TAG_LIFE, this.getLife());
        cmp.func_74768_a(TAG_DAMAGE, this.getDamage());
        cmp.func_74776_a(TAG_PITCH, this.getPitch());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
        this.setLife(cmp.func_74762_e(TAG_LIFE));
        this.setDamage(cmp.func_74762_e(TAG_DAMAGE));
        this.setPitch(cmp.func_74760_g(TAG_PITCH));
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }

    public float getPitch() {
        return ((Float)this.field_70180_af.func_187225_a(PITCH)).floatValue();
    }

    public void setPitch(float rot) {
        this.field_70180_af.func_187227_b(PITCH, (Object)Float.valueOf(rot));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int delay) {
        this.field_70180_af.func_187227_b(LIFE, (Object)delay);
    }

    public int getDamage() {
        return (Integer)this.field_70180_af.func_187225_a(DAMAGE);
    }

    public void setDamage(int delay) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)delay);
    }

    private Status getStatus() {
        if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177963_a(0.0, (double)-1.9f, 0.0)).func_177230_c() != Blocks.field_150350_a) {
            return Status.STANDBY;
        }
        return Status.INAIR;
    }

    @Override
    public boolean isBoss(Entity p) {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public static enum Status {
        INAIR,
        STANDBY;

    }
}

