/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.judah;

import com.google.common.base.Optional;
import com.meteor.extrabotany.ExtraBotany;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.brew.ModPotions;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import vazkii.botania.common.Botania;

public class EntityJudahSpear
extends Entity {
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_FAKE = "fake";
    private static final String TAG_FLAG = "flag";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_PLAYERLIST = "playerlist";
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityJudahSpear.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FAKE = EntityDataManager.func_187226_a(EntityJudahSpear.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLAG = EntityDataManager.func_187226_a(EntityJudahSpear.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityJudahSpear.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityJudahSpear.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> UUID = EntityDataManager.func_187226_a(EntityJudahSpear.class, (DataSerializer)DataSerializers.field_187203_m);
    private static EntityPlayer thrower;

    public EntityJudahSpear(World worldIn) {
        super(worldIn);
    }

    public EntityJudahSpear(EntityPlayer thrower, World worldIn) {
        super(worldIn);
        EntityJudahSpear.thrower = thrower;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FAKE, (Object)false);
        this.field_70180_af.func_187214_a(FLAG, (Object)false);
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TYPE, (Object)Type.JUDAH.ordinal());
        this.field_70180_af.func_187214_a(UUID, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (this.getType().metadata) {
            case 0: {
                r = 0.85f;
                g = 0.6f;
                b = 0.02f;
                break;
            }
            case 1: {
                r = 0.01f;
                g = 0.6f;
                b = 0.75f;
                break;
            }
            case 2: {
                break;
            }
        }
        Botania.proxy.sparkleFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, r, g, b, 1.0f, 1);
        super.func_70071_h_();
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70163_u = this.getFake() ? (this.field_70163_u += 0.75) : (this.field_70163_u -= (double)0.95f);
        if (!this.field_70170_p.field_72995_K && !this.getFake()) {
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - (double)1.3f, this.field_70163_u - 6.0, this.field_70161_v - (double)1.3f, this.field_70142_S + (double)1.3f, this.field_70137_T + 5.0, this.field_70136_U + (double)1.3f);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase living : entities) {
                if (living.func_110124_au() == this.getUUID() || FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() && living instanceof EntityPlayer || this.getFlag()) continue;
                for (int i = 0; i < 4; ++i) {
                    Botania.proxy.wispFX(living.field_70165_t, living.field_70163_u + 0.5, living.field_70161_v, r, g, b, 0.45f, (float)(Math.random() - 0.5) * 0.5f, (float)(Math.random() - 0.5) * 0.5f, (float)(Math.random() - 0.5) * 0.5f);
                }
                if (ExtraBotany.isTableclothServer && thrower != null) {
                    living.func_70097_a(DamageSource.func_76365_a((EntityPlayer)thrower), this.getDamage() * 1.6f);
                } else {
                    living.func_70097_a(DamageSource.field_180137_b, this.getDamage() * 1.6f);
                }
                if (living.func_184222_aU()) {
                    ExtraBotanyAPI.addPotionEffect(living, ModPotions.divinejustice, 4);
                }
                ExtraBotanyAPI.dealTrueDamage((EntityLivingBase)thrower, living, this.getDamage() * 0.15f);
                this.setFlag(true);
            }
        }
        if (this.field_70173_aa > 100) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound cmp) {
        cmp.func_74778_a("Type", this.getType().getName());
        cmp.func_74776_a(TAG_DAMAGE, this.getDamage());
        cmp.func_74757_a(TAG_FAKE, this.getFake());
        cmp.func_74757_a(TAG_FLAG, this.getFlag());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
        cmp.func_186854_a(TAG_PLAYERLIST, this.getUUID());
    }

    public void func_70037_a(NBTTagCompound cmp) {
        if (cmp.func_150297_b("Type", 8)) {
            this.setType(Type.getTypeFromString(cmp.func_74779_i("Type")));
        }
        this.setDamage(cmp.func_74760_g(TAG_DAMAGE));
        this.setFake(cmp.func_74767_n(TAG_FAKE));
        this.setFlag(cmp.func_74767_n(TAG_FLAG));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
        this.setUUID(cmp.func_186857_a(TAG_PLAYERLIST));
    }

    public UUID getUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(UUID)).orNull();
    }

    public void setUUID(UUID u) {
        this.field_70180_af.func_187227_b(UUID, (Object)Optional.fromNullable((Object)u));
    }

    public Type getType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    public void setType(Type raftType) {
        this.field_70180_af.func_187227_b(TYPE, (Object)raftType.ordinal());
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float delay) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(delay));
    }

    public boolean getFake() {
        return (Boolean)this.field_70180_af.func_187225_a(FAKE);
    }

    public void setFake(boolean delay) {
        this.field_70180_af.func_187227_b(FAKE, (Object)delay);
    }

    public boolean getFlag() {
        return (Boolean)this.field_70180_af.func_187225_a(FLAG);
    }

    public void setFlag(boolean delay) {
        this.field_70180_af.func_187227_b(FLAG, (Object)delay);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }

    public static enum Type {
        JUDAH(0, "judah"),
        KIRA(1, "kira"),
        SAKURA(2, "sakura");

        private final String name;
        private final int metadata;

        private Type(int metadataIn, String nameIn) {
            this.name = nameIn;
            this.metadata = metadataIn;
        }

        public static Type byId(int id) {
            if (id < 0 || id >= Type.values().length) {
                id = 0;
            }
            return Type.values()[id];
        }

        public static Type getTypeFromString(String nameIn) {
            for (int i = 0; i < Type.values().length; ++i) {
                if (!Type.values()[i].getName().equals(nameIn)) continue;
                return Type.values()[i];
            }
            return Type.values()[0];
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name;
        }
    }
}

