/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.integration.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAction;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.meteor.extrabotany.ExtraBotany;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.crafting.recipe.RecipeStonesia;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extrabotany.Stonesia")
@ModOnly(value="extrabotany")
@ZenRegister
public class Stonesia {
    @ZenMethod
    public static void add(int output, IItemStack input) {
        ExtraBotany.LATE_ADDITIONS.add((IAction)new AddShaped(output, input));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        ExtraBotany.LATE_REMOVALS.add((IAction)new RemoveShaped(input));
    }

    public static class RemoveShaped
    extends BaseListRemoval<RecipeStonesia> {
        private final IItemStack input;

        protected RemoveShaped(IItemStack input) {
            super("Remove Stonesia Recipe", ExtraBotanyAPI.stonesiaRecipes);
            this.input = input;
        }

        public void apply() {
            LinkedList<RecipeStonesia> recipes = new LinkedList<RecipeStonesia>();
            for (RecipeStonesia entry : ExtraBotanyAPI.stonesiaRecipes) {
                if (entry == null || entry.getInput() == null || !(entry.getInput() instanceof ItemStack) || !StackHelper.matches((IIngredient)this.input, (IItemStack)InputHelper.toIItemStack((ItemStack)((ItemStack)entry.getInput())))) continue;
                recipes.add(entry);
            }
            if (!recipes.isEmpty()) {
                this.recipes.addAll(recipes);
                super.apply();
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        protected String getRecipeInfo(RecipeStonesia arg0) {
            return this.input.getDisplayName();
        }
    }

    public static class AddShaped
    extends BaseAction {
        private final int output;
        private final IItemStack input;

        public AddShaped(int output, IItemStack input) {
            super("Add Stonesia Recipe");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            ExtraBotanyAPI.registerStonesiaRecipe(this.output, InputHelper.toStack((IItemStack)this.input));
        }

        protected String getRecipeInfo() {
            return this.input.getDisplayName();
        }
    }
}

