/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.armor.goblinslayer;

import com.google.common.collect.Multimap;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.client.model.ModelArmorGoblinSlayerNew;
import com.meteor.extrabotany.common.item.ModItems;
import com.meteor.extrabotany.common.item.equipment.armor.cosmeticmaid.ItemCosmeticMaidArmor;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemGoblinSlayerArmor
extends ItemCosmeticMaidArmor {
    public static final String TAG_DAY = "isday";
    private static ItemStack[] armorset;

    public ItemGoblinSlayerArmor(EntityEquipmentSlot type, String name) {
        super(type, name, ExtraBotanyAPI.goblinslayerArmorMaterial);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, EntityEquipmentSlot slot) {
        this.models.put(slot, new ModelArmorGoblinSlayerNew(slot));
        return (ModelBiped)this.models.get(slot);
    }

    public float getDiscount(ItemStack stack, int slot, EntityPlayer player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.1f : 0.0f;
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EntityEquipmentSlot slot) {
        return "extrabotany:textures/model/armor_goblinslayernew.png";
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this.hasArmorSet(player) && world.func_72935_r()) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_DAY, (boolean)true);
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_DAY, (boolean)false);
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> attrib = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        boolean night = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_DAY, (boolean)false);
        if (slot == this.field_77881_a) {
            attrib.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(uuid, "GoblinSlayer modifier " + this.type, night ? 0.5 : 0.0, 1));
            attrib.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid, "GoblinSlayer modifier " + this.type, night ? (double)0.04f : 0.0, 1));
        }
        return attrib;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        if (armorset == null) {
            armorset = new ItemStack[]{new ItemStack(ModItems.gshelm), new ItemStack(ModItems.gschest), new ItemStack(ModItems.gsleg), new ItemStack(ModItems.gsboot)};
        }
        return armorset;
    }

    @Override
    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.gshelm;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.gschest;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.gsleg;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.gsboot;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        this.addStringToTooltip(I18n.func_135052_a((String)"extrabotany.armorset.goblinslayer.desc0", (Object[])new Object[0]), list);
        this.addStringToTooltip(I18n.func_135052_a((String)"extrabotany.armorset.goblinslayer.desc1", (Object[])new Object[0]), list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getArmorSetName() {
        return I18n.func_135052_a((String)"extrabotany.armorset.goblinslayer.name", (Object[])new Object[0]);
    }
}

