/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.meteor.extrabotany.common.item.ItemMod;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

@Mod.EventBusSubscriber(modid="extrabotany")
public abstract class ItemBauble
extends ItemMod
implements IBauble,
ICosmeticAttachable,
IPhantomInkable {
    private static final String TAG_HASHCODE = "playerHashcode";
    private static final String TAG_BAUBLE_UUID_MOST = "baubleUUIDMost";
    private static final String TAG_BAUBLE_UUID_LEAST = "baubleUUIDLeast";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";
    private static final String TAG_PHANTOM_INK = "phantomInk";

    public ItemBauble(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent evt) {
        if (!evt.getEntityLiving().field_70170_p.field_72995_K && evt.getEntityLiving() instanceof EntityPlayer && !evt.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("keepInventory") && !((EntityPlayer)evt.getEntityLiving()).func_175149_v()) {
            IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)evt.getEntityLiving()));
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b() || !stack.func_77973_b().getRegistryName().func_110624_b().equals("extrabotany")) continue;
                ((ItemBauble)stack.func_77973_b()).onUnequipped(stack, evt.getEntityLiving());
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!EntityDoppleganger.isTruePlayer((Entity)player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        ItemStack toEquip = stack.func_77946_l();
        toEquip.func_190920_e(1);
        if (this.canEquip(toEquip, (EntityLivingBase)player)) {
            if (world.field_72995_K) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stackInSlot;
                if (!baubles.isItemValidForSlot(i, toEquip, (EntityLivingBase)player) || !(stackInSlot = baubles.getStackInSlot(i)).func_190926_b() && !((IBauble)stackInSlot.func_77973_b()).canUnequip(stackInSlot, (EntityLivingBase)player)) continue;
                baubles.setStackInSlot(i, ItemStack.field_190927_a);
                baubles.setStackInSlot(i, toEquip);
                ((IBauble)toEquip.func_77973_b()).onEquipped(toEquip, (EntityLivingBase)player);
                stack.func_190918_g(1);
                PlayerHelper.grantCriterion((EntityPlayerMP)((EntityPlayerMP)player), (ResourceLocation)new ResourceLocation("extrabotany", "main/bauble_wear"), (String)"code_triggered");
                if (!stackInSlot.func_190926_b()) {
                    ((IBauble)stackInSlot.func_77973_b()).onUnequipped(stackInSlot, (EntityLivingBase)player);
                    if (stack.func_190926_b()) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stackInSlot);
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackInSlot);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        if (GuiScreen.func_146272_n()) {
            this.addHiddenTooltip(par1ItemStack, world, stacks, flags);
        } else {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), stacks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        ItemStack cosmetic;
        String key = RenderHelper.getKeyDisplayString((String)"Baubles Inventory");
        if (key != null) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botania.baubletooltip", (Object[])new Object[]{key}), stacks);
        }
        if (!(cosmetic = this.getCosmeticItem(par1ItemStack)).func_190926_b()) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.hasCosmetic", (Object[])new Object[]{cosmetic.func_82833_r()}), stacks);
        }
        if (this.hasPhantomInk(par1ItemStack)) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.hasPhantomInk", (Object[])new Object[0]), stacks);
        }
    }

    public void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (ItemBauble.getLastPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            ItemBauble.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (player != null) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.equipBauble, SoundCategory.PLAYERS, 0.1f, 1.3f);
                PlayerHelper.grantCriterion((EntityPlayerMP)((EntityPlayerMP)player), (ResourceLocation)new ResourceLocation("extrabotany", "main/bauble_wear"), (String)"code_triggered");
            }
            this.onEquippedOrLoadedIntoWorld(stack, player);
            ItemBauble.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    public ItemStack getCosmeticItem(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_COSMETIC_ITEM, (boolean)true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (!cosmetic.func_190926_b()) {
            cmp = cosmetic.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_COSMETIC_ITEM, (NBTTagCompound)cmp);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return this.getCosmeticItem(itemStack);
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        long most = ItemNBTHelper.getLong((ItemStack)stack, (String)TAG_BAUBLE_UUID_MOST, (long)0L);
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            ItemNBTHelper.setLong((ItemStack)stack, (String)TAG_BAUBLE_UUID_MOST, (long)uuid.getMostSignificantBits());
            ItemNBTHelper.setLong((ItemStack)stack, (String)TAG_BAUBLE_UUID_LEAST, (long)uuid.getLeastSignificantBits());
            return ItemBauble.getBaubleUUID(stack);
        }
        long least = ItemNBTHelper.getLong((ItemStack)stack, (String)TAG_BAUBLE_UUID_LEAST, (long)0L);
        return new UUID(most, least);
    }

    public static int getLastPlayerHashcode(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_HASHCODE, (int)0);
    }

    public static void setLastPlayerHashcode(ItemStack stack, int hash) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_HASHCODE, (int)hash);
    }

    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_PHANTOM_INK, (boolean)false);
    }

    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_PHANTOM_INK, (boolean)ink);
    }
}

