/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaubleType;
import com.meteor.extrabotany.client.core.handler.MiscellaneousIcons;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBauble;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemPureDaisyPendant
extends ItemBauble
implements IManaUsingItem,
ICosmeticBauble {
    public static final String TAG_USE = "usecount";
    public static final String TAG_CD = "cooldown";
    private ItemStack renderStack;

    public ItemPureDaisyPendant() {
        super("puredaisypendant");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.func_175623_d(pos)) {
            world.field_72984_F.func_76320_a("findRecipe");
            RecipePureDaisy recipe = this.findRecipe(world, pos);
            world.field_72984_F.func_76319_b();
            ItemStack stack = player.func_184586_b(hand);
            if (recipe != null && this.getCD(stack) == 0) {
                if (recipe.set(world, pos, new SubTileEntity()) && ManaItemHandler.requestManaExactForTool((ItemStack)player.func_184586_b(hand), (EntityPlayer)player, (int)50, (boolean)true)) {
                    world.func_175641_c(pos, recipe.getOutputState().func_177230_c(), 1, 1);
                }
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)recipe.getOutputState()));
                this.setCount(stack, this.getCount(stack) + 1);
                if (this.getCount(stack) % 64 == 0) {
                    this.setCD(stack, 3000);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private RecipePureDaisy findRecipe(World world, BlockPos coords) {
        IBlockState state = world.func_180495_p(coords);
        for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
            if (!recipe.matches(world, coords, new SubTileEntity(), state)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<String> stacks, ITooltipFlag flags) {
        this.addStringToTooltip("Cooldown:" + this.getCD(stack) + "ticks", stacks);
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        if (this.getCD(stack) > 0) {
            this.setCD(stack, this.getCD(stack) - 1);
        }
        if (player.func_130014_f_().func_72935_r() && player.func_130014_f_().func_72820_D() % 120L == 0L) {
            player.func_70691_i(1.0f);
        }
    }

    private boolean isOreDict(ItemStack stack, String entry) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack ostack : OreDictionary.getOres((String)entry, (boolean)false)) {
            if (!OreDictionary.itemMatches((ItemStack)ostack, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    public boolean usesMana(ItemStack arg0) {
        return true;
    }

    public void setCD(ItemStack stack, int i) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_CD, (int)i);
    }

    public int getCD(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_CD, (int)0);
    }

    public void setCount(ItemStack stack, int i) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_USE, (int)i);
    }

    public int getCount(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_USE, (int)0);
    }

    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderStack = stack;
        if (type == IBaubleRender.RenderType.BODY) {
            IBaubleRender.Helper.rotateIfSneaking((EntityPlayer)player);
            boolean armor = !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.3f, (float)-0.57f, (float)(armor ? 0.2f : 0.15f));
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            TextureAtlasSprite gemIcon = MiscellaneousIcons.INSTANCE.puredaisyPendantIcon;
            float f = gemIcon.func_94209_e();
            float f1 = gemIcon.func_94212_f();
            float f2 = gemIcon.func_94206_g();
            float f3 = gemIcon.func_94210_h();
            IconHelper.renderIconIn3D((Tessellator)Tessellator.func_178181_a(), (float)f1, (float)f2, (float)f, (float)f3, (int)gemIcon.func_94211_a(), (int)gemIcon.func_94216_b(), (float)0.03125f);
        }
    }
}

