/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meteor.extrabotany.common.brew.ModPotions;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBaubleRelic;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemFrostStar;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemSilentEternity
extends ItemBaubleRelic
implements IManaItem {
    protected static final int MAX_MANA = 666;
    private static final String TAG_MANA = "mana";
    private static final String TAG_X = "posx";
    private static final String TAG_Y = "posy";
    private static final String TAG_Z = "posz";
    private static final String TAG_STOPTICKS = "stopticks";

    public ItemSilentEternity() {
        super("silenteternity");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerHeal(LivingHealEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)this) != -1) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        super.onWornTick(stack, entity);
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        this.addMana(stack, 666);
        if (!entity.field_70170_p.field_72995_K) {
            boolean lastOnGround = entity.field_70122_E;
            entity.field_70122_E = true;
            EnchantmentFrostWalker.func_185266_a((EntityLivingBase)entity, (World)entity.field_70170_p, (BlockPos)new BlockPos((Entity)entity), (int)4);
            ItemFrostStar.freezeLava(entity, entity.field_70170_p, new BlockPos((Entity)entity), 4);
            entity.field_70122_E = lastOnGround;
            if (this.getX(stack) == player.field_70165_t && this.getY(stack) == player.field_70163_u && this.getZ(stack) == player.field_70161_v) {
                this.setStopticks(stack, this.getStopticks(stack) + 1);
                if (this.getStopticks(stack) > 15) {
                    player.func_70606_j(Math.min(player.func_110138_aP(), player.func_110143_aJ() + 0.4f));
                    player.func_70690_d(new PotionEffect(ModPotions.eternity, 10));
                }
            } else {
                this.setStopticks(stack, 0);
            }
            this.setX(stack, player.field_70142_S);
            this.setY(stack, player.field_70137_T);
            this.setZ(stack, player.field_70136_U);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.TRINKET;
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MANA, (int)mana);
    }

    public double getX(ItemStack stack) {
        return ItemNBTHelper.getDouble((ItemStack)stack, (String)TAG_X, (double)0.0);
    }

    public double getY(ItemStack stack) {
        return ItemNBTHelper.getDouble((ItemStack)stack, (String)TAG_Y, (double)0.0);
    }

    public double getZ(ItemStack stack) {
        return ItemNBTHelper.getDouble((ItemStack)stack, (String)TAG_Z, (double)0.0);
    }

    public void setX(ItemStack stack, double d) {
        ItemNBTHelper.setDouble((ItemStack)stack, (String)TAG_X, (double)d);
    }

    public void setY(ItemStack stack, double d) {
        ItemNBTHelper.setDouble((ItemStack)stack, (String)TAG_Y, (double)d);
    }

    public void setZ(ItemStack stack, double d) {
        ItemNBTHelper.setDouble((ItemStack)stack, (String)TAG_Z, (double)d);
    }

    public int getStopticks(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_STOPTICKS, (int)0);
    }

    public void setStopticks(ItemStack stack, int i) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_STOPTICKS, (int)i);
    }

    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MANA, (int)0);
    }

    public int getMaxMana(ItemStack stack) {
        return 666;
    }

    public void addMana(ItemStack stack, int mana) {
        ItemSilentEternity.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)));
    }

    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111147_b((Multimap)attributes);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111148_a((Multimap)attributes);
        }
    }

    void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ItemSilentEternity.getBaubleUUID(stack), "SILENTETERNITY", 1.0, 0).func_111168_a(false));
    }
}

