/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.shield;

import com.meteor.extrabotany.ExtraBotanyCreativeTab;
import com.meteor.extrabotany.client.render.IModelReg;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShieldCopy
extends ItemShield
implements IModelReg {
    private Item.ToolMaterial material;
    private String name;

    public ItemShieldCopy(Item.ToolMaterial material, String name) {
        this.func_77637_a(ExtraBotanyCreativeTab.INSTANCE);
        this.setRegistryName(new ResourceLocation("extrabotany", name));
        this.func_77655_b(name);
        this.name = name;
        this.material = material;
        this.func_77656_e(material.func_77997_a() * 2);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)("item.extrabotany:" + this.name + ".name"));
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item\\.", "item.extrabotany:");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public boolean isShield(ItemStack stack, EntityLivingBase entity) {
        return true;
    }

    public int getShieldBlockingCooldown(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0;
    }

    public void onAttackBlocked(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        EntityLivingBase attacker;
        ItemStack attackerItem;
        if (!attacked.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityLivingBase && !(attackerItem = (attacker = (EntityLivingBase)source.func_76346_g()).func_184614_ca()).func_190926_b() && attackerItem.func_77973_b().canDisableShield(attackerItem, stack, attacked, attacker)) {
            float attackStrength = attacker instanceof EntityPlayer ? ((EntityPlayer)attacker).func_184825_o(0.5f) : 1.0f;
            float criticalChance = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)attacker) * 0.05f;
            if (attacker.func_70051_ag() && attackStrength > 0.9f) {
                criticalChance += 0.75f;
            }
            if (attacked.field_70170_p.field_73012_v.nextFloat() < criticalChance) {
                if (attacked instanceof EntityPlayer) {
                    ((EntityPlayer)attacked).func_184811_cZ().func_185145_a((Item)this, 100);
                    attacked.func_184597_cx();
                }
                attacked.field_70170_p.func_72960_a((Entity)attacked, (byte)30);
            }
        }
    }

    public float getBlockedDamage(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0.0f;
    }

    public float getDefenderKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0.6f - Math.min((float)this.material.func_77997_a() / 2500.0f, 1.0f) * 0.6f;
    }

    public float getAttackerKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 0.6f;
    }

    public boolean canBlockDamageSource(ItemStack stack, EntityLivingBase attacked, EnumHand hand, DamageSource source) {
        Vec3d vec3d;
        if (attacked.func_184587_cr() && attacked.func_184600_cs() == hand && !source.func_76363_c() && attacked.func_184585_cz() && (vec3d = source.func_188404_v()) != null) {
            Vec3d vec3d1 = attacked.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(attacked.field_70165_t, attacked.field_70163_u, attacked.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static enum EventHandler {
        INSTANCE;

        private boolean ignoreEvent = false;

        @SubscribeEvent
        public void onLivingAttacked(LivingAttackEvent event) {
            if (this.ignoreEvent) {
                return;
            }
            this.ignoreEvent = true;
            EntityLivingBase attacked = event.getEntityLiving();
            DamageSource source = event.getSource();
            for (EnumHand hand : EnumHand.values()) {
                int cooldown;
                float attackerKbMultiplier;
                ItemShieldCopy shield;
                ItemStack stack = attacked.func_184586_b(hand);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemShieldCopy) || !(shield = (ItemShieldCopy)stack.func_77973_b()).canBlockDamageSource(stack, attacked, hand, source)) continue;
                if (!attacked.field_70170_p.field_72995_K) {
                    event.setCanceled(true);
                }
                if (!attacked.field_70170_p.field_72995_K) {
                    float defenderKbMultiplier = shield.getDefenderKnockbackMultiplier(stack, attacked, event.getAmount(), source);
                    float newDamage = shield.getBlockedDamage(stack, attacked, event.getAmount(), source);
                    if (newDamage > 0.0f) {
                        double prevMotionX = attacked.field_70159_w;
                        double prevMotionY = attacked.field_70181_x;
                        double prevMotionZ = attacked.field_70179_y;
                        Object newSource = source instanceof EntityDamageSourceIndirect ? new EntityDamageSourceIndirect(source.field_76373_n, source.func_76364_f(), source.func_76346_g()){

                            public Vec3d func_188404_v() {
                                return null;
                            }
                        } : (source instanceof EntityDamageSource ? new EntityDamageSource(source.field_76373_n, source.func_76346_g()){

                            public Vec3d func_188404_v() {
                                return null;
                            }
                        } : new DamageSource(source.field_76373_n){

                            public Vec3d func_188404_v() {
                                return null;
                            }
                        });
                        if (source.func_151517_h()) {
                            newSource.func_151518_m();
                        }
                        if (source.func_76363_c()) {
                            newSource.func_76348_h();
                        }
                        if (source.func_76347_k()) {
                            newSource.func_76361_j();
                        }
                        if (source.func_82725_o()) {
                            newSource.func_82726_p();
                        }
                        if (source.func_76350_n()) {
                            newSource.func_76351_m();
                        }
                        if (source.func_94541_c()) {
                            newSource.func_94540_d();
                        }
                        if (source.func_76352_a()) {
                            newSource.func_76349_b();
                        }
                        attacked.func_70097_a(newSource, newDamage);
                        attacked.field_70159_w = prevMotionX;
                        attacked.field_70181_x = prevMotionY;
                        attacked.field_70179_y = prevMotionZ;
                    }
                    if (source.func_76346_g() != null) {
                        double prevMotionY = attacked.field_70181_x;
                        attacked.func_70653_a(source.func_76346_g(), defenderKbMultiplier, source.func_76346_g().field_70165_t - attacked.field_70165_t, source.func_76346_g().field_70161_v - attacked.field_70161_v);
                        attacked.field_70181_x = prevMotionY;
                        attacked.field_70133_I = true;
                    }
                    attacked.field_70170_p.func_72960_a((Entity)attacked, (byte)29);
                }
                if (!attacked.field_70170_p.field_72995_K && source.func_76346_g() == source.func_76364_f() && source.func_76346_g() instanceof EntityLivingBase && (attackerKbMultiplier = shield.getAttackerKnockbackMultiplier(stack, attacked, event.getAmount(), source)) > 0.0f) {
                    ((EntityLivingBase)source.func_76346_g()).func_70653_a((Entity)attacked, attackerKbMultiplier, attacked.field_70165_t - source.func_76346_g().field_70165_t, attacked.field_70161_v - source.func_76346_g().field_70161_v);
                }
                if (attacked instanceof EntityPlayer && (cooldown = shield.getShieldBlockingCooldown(stack, (EntityLivingBase)((EntityPlayer)attacked), event.getAmount(), source)) > 0) {
                    ((EntityPlayer)attacked).func_184811_cZ().func_185145_a((Item)shield, cooldown);
                    attacked.func_184597_cx();
                }
                shield.onAttackBlocked(stack, attacked, event.getAmount(), source);
                if (attacked.field_70170_p.field_72995_K) break;
                int itemDamage = 1 + MathHelper.func_76141_d((float)event.getAmount());
                stack.func_77972_a(itemDamage, attacked);
                if (stack.func_190916_E() > 0) break;
                EnumHand enumhand = attacked.func_184600_cs();
                if (attacked instanceof EntityPlayer) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)((EntityPlayer)attacked), (ItemStack)stack, (EnumHand)enumhand);
                }
                if (enumhand == EnumHand.MAIN_HAND) {
                    attacked.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    attacked.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                attacked.field_70170_p.func_72960_a((Entity)attacked, (byte)30);
                break;
            }
            this.ignoreEvent = false;
        }
    }
}

