/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.tool;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.item.equipment.tool.ItemHammer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemHammerUltimate
extends ItemHammer
implements IManaItem,
ISequentialBreaker {
    private static final List<Material> MATERIALS = Arrays.asList(Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B);
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final String TAG_REPAIRUPGRADE = "repair";
    private static final String TAG_DAMAGEUPGRADE = "damage";
    private static final String TAG_RANGE = "range";
    private static final int MAX_MANA = 50000;
    private static final int MANA_PER_DAMAGE = 80;
    private static HashSet<Block> effectiveAgainst = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw, Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da});

    public ItemHammerUltimate() {
        super("ultimatehammer", ExtraBotanyAPI.ultimateHammer);
        this.func_77656_e(3000);
        this.func_185043_a(new ResourceLocation("extrabotany", TAG_ENABLED), (itemStack, world, entityLivingBase) -> ItemHammerUltimate.isEnabled(itemStack) ? 1.0f : 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        String repair = I18n.func_135052_a((String)("extrabotany.repairupgrade" + this.getRepair(par1ItemStack)), (Object[])new Object[0]);
        String attack = I18n.func_135052_a((String)("extrabotany.damageupgrade" + this.getAttack(par1ItemStack)), (Object[])new Object[0]);
        String range = I18n.func_135052_a((String)"extrabotany.rangeupgrade", (Object[])new Object[0]);
        if (this.getAttack(par1ItemStack) > 0) {
            stacks.add(attack);
        }
        if (this.getRepair(par1ItemStack) > 0) {
            stacks.add(repair);
        }
        if (ItemHammerUltimate.hasRange(par1ItemStack)) {
            stacks.add(range);
        }
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemHammerUltimate.hasRange(stack)) {
            this.setEnabled(stack, !ItemHammerUltimate.isEnabled(stack));
            if (!world.field_72995_K) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.terraPickMode, SoundCategory.PLAYERS, 0.5f, 0.4f);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float sx, float sy, float sz) {
        return player.func_70093_af() ? super.func_180614_a(player, world, pos, hand, side, sx, sy, sz) : EnumActionResult.PASS;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static void setRepair(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_REPAIRUPGRADE, (int)mana);
    }

    public int getRepair(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_REPAIRUPGRADE, (int)0);
    }

    public static void setAttack(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_DAMAGEUPGRADE, (int)mana);
    }

    public int getAttack(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_DAMAGEUPGRADE, (int)0);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.getAttack(stack) > 0 && ManaItemHandler.requestManaExact((ItemStack)stack, (EntityPlayer)((EntityPlayer)attacker), (int)(80 * this.getAttack(stack) - this.getRepair(stack) * 15), (boolean)true)) {
            if (this.getAttack(stack) > 1) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1));
            }
            if (this.getAttack(stack) > 3) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 1));
            }
            if (this.getAttack(stack) > 5) {
                target.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 100, 2));
            }
            if (this.getAttack(stack) > 7) {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 2));
            }
            if (this.getAttack(stack) > 9) {
                attacker.func_70691_i(4.0f);
            }
            target.func_70097_a(DamageSource.field_76376_m, 2.0f * (float)this.getAttack(stack));
        }
        return true;
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MANA, (int)mana);
    }

    public int getMana(ItemStack stack) {
        return ItemHammerUltimate.getMana_(stack);
    }

    public static int getMana_(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MANA, (int)0);
    }

    public int getMaxMana(ItemStack stack) {
        return 50000;
    }

    public static boolean hasRange(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_RANGE, (boolean)false);
    }

    public void setRange(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_RANGE, (boolean)enabled);
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_ENABLED, (boolean)false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_ENABLED, (boolean)enabled);
    }

    public void addMana(ItemStack stack, int mana) {
        ItemHammerUltimate.setMana(stack, Math.min(this.getMana(stack) + mana, 50000));
    }

    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !(otherStack.func_77973_b() instanceof IManaGivingItem);
    }

    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean isNoExport(ItemStack stack) {
        return true;
    }

    @Override
    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        if (!world.field_72995_K && par3Entity.field_70173_aa % (40 - this.getRepair(par1ItemStack) * 10) == 0 && ManaItemHandler.requestManaExact((ItemStack)par1ItemStack, (EntityPlayer)((EntityPlayer)par3Entity), (int)(ItemHammerUltimate.getManaPerDamage() - this.getRepair(par1ItemStack) * 5), (boolean)true) && par1ItemStack.func_77952_i() > 0) {
            par1ItemStack.func_77964_b(par1ItemStack.func_77952_i() - 1);
        }
    }

    public static int getManaPerDamage() {
        return 80;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"spade", (Object)"axe");
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        RayTraceResult raycast = ToolCommons.raytraceFromEntity((World)player.field_70170_p, (Entity)player, (boolean)true, (double)10.0);
        if (!player.field_70170_p.field_72995_K && raycast != null) {
            this.breakOtherBlock(player, stack, pos, pos, raycast.field_178784_b);
        }
        return false;
    }

    public void breakOtherBlock(EntityPlayer player, ItemStack stack, BlockPos pos, BlockPos originPos, EnumFacing side) {
        if (!ItemHammerUltimate.isEnabled(stack)) {
            return;
        }
        World world = player.field_70170_p;
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!MATERIALS.contains(mat)) {
            return;
        }
        if (world.func_175623_d(pos)) {
            return;
        }
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean silk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        boolean doX = side.func_82601_c() == 0;
        boolean doY = side.func_96559_d() == 0;
        boolean doZ = side.func_82599_e() == 0;
        int level = 2;
        int range = level - 1;
        int rangeY = Math.max(1, range);
        Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vec3i endDiff = new Vec3i(doX ? range : 0, doY ? rangeY * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration((EntityPlayer)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vec3i)beginDiff, (Vec3i)endDiff, state -> MATERIALS.contains(state.func_185904_a()), (boolean)silk);
        stack.func_77972_a(8, (EntityLivingBase)player);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return effectiveAgainst.contains(blockIn.func_177230_c()) ? true : super.func_150897_b(blockIn);
    }

    public boolean disposeOfTrashBlocks(ItemStack arg0) {
        return false;
    }
}

