/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.relic;

import com.google.common.collect.Multimap;
import com.meteor.extrabotany.api.item.IAdvancementRequired;
import com.meteor.extrabotany.common.entity.EntityItemUnbreakable;
import com.meteor.extrabotany.common.item.equipment.shield.ItemManasteelShield;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPixieSpawner;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ItemThunderSword;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemAchilleshield
extends ItemManasteelShield
implements IRelic,
IPixieSpawner,
IAdvancementRequired {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";
    private static final String TAG_LIGHTNING_SEED = "lightningSeed";
    private static final String TAG_MODE = "mode";

    public ItemAchilleshield() {
        super(BotaniaAPI.terrasteelToolMaterial, "achilleshield");
        this.func_185043_a(new ResourceLocation("release"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && ItemAchilleshield.this.isReleased(stack) ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af() && playerIn.func_110139_bj() >= 12.0f) {
            this.setReleased(playerIn.func_184586_b(hand), !this.isReleased(playerIn.func_184586_b(hand)));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        if (!this.isReleased(playerIn.func_184586_b(hand))) {
            playerIn.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, @Nonnull EntityLivingBase attacker) {
        ItemThunderSword sword = new ItemThunderSword();
        if (this.isReleased(stack)) {
            sword.func_77644_a(stack, entity, attacker);
        } else {
            attacker.func_110149_m(Math.min(20.0f, attacker.func_110139_bj() + 2.0f));
        }
        return super.func_77644_a(stack, entity, attacker);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            attrib.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", this.isReleased(stack) ? 15.0 : 6.0, 0));
            attrib.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.6, 0));
            attrib.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid, "Tool modifier", this.isReleased(stack) ? (double)0.4f : 0.0, 1));
        }
        return attrib;
    }

    public boolean isReleased(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_MODE, (boolean)false);
    }

    public void setReleased(ItemStack stack, boolean mode) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_MODE, (boolean)mode);
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityItemUnbreakable(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
    }

    public void onEnemyRammed(ItemStack stack, EntityLivingBase user, EntityLivingBase enemy, Vec3d rammingDir) {
        int knockback = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack);
        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
        enemy.func_70653_a((Entity)user, 1.5f * (float)(1 + knockback), -rammingDir.field_72450_a, -rammingDir.field_72449_c);
        if (user instanceof EntityPlayer) {
            enemy.func_70097_a(DamageSource.field_76376_m, 13.0f + 1.5f * (float)power);
        }
    }

    @Override
    public void onAttackBlocked(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        EntityDamageSourceIndirect indirectSource;
        EntityPlayer player;
        if (source.func_76364_f() != null && attacked instanceof EntityPlayer && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)(player = (EntityPlayer)attacked), (int)500, (boolean)true)) {
            source.func_76364_f().func_70097_a(DamageSource.field_76376_m, damage);
        }
        if (source instanceof EntityDamageSourceIndirect && (indirectSource = (EntityDamageSourceIndirect)source).func_76364_f() != null && indirectSource.func_76346_g() != null && indirectSource.func_76364_f() instanceof IProjectile) {
            Vec3d dir = indirectSource.func_76364_f().func_174824_e(1.0f).func_178788_d(indirectSource.func_76346_g().func_174824_e(1.0f)).func_72432_b();
            ((IProjectile)indirectSource.func_76364_f()).func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, 15.0f, 2.0f);
            if (indirectSource.func_76364_f() instanceof EntityArrow) {
                ((EntityArrow)indirectSource.func_76364_f()).field_70250_c = attacked;
            }
        }
        super.onAttackBlocked(stack, attacked, damage, source);
    }

    @Override
    public int getRepairSpeed() {
        return 5;
    }

    @Override
    public float getAttackerKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 1.75f;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        if (this.isReleased(stack)) {
            player.func_184597_cx();
        }
        if ((player.field_70159_w > 0.0 || player.field_70179_y > 0.0) && player.func_184587_cr()) {
            Vec3d moveDir = new Vec3d(player.field_70159_w, player.field_70181_x, player.field_70179_y).func_72432_b();
            List targets = player.field_70170_p.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(1.0), e -> e != player);
            for (EntityLivingBase target : targets) {
                this.onEnemyRammed(stack, player, target, moveDir);
            }
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.isReleased(stack) && player.field_70173_aa % 10 == 0) {
                if (player.func_110139_bj() > 0.0f) {
                    player.func_110149_m(player.func_110139_bj() - 1.0f);
                } else {
                    this.setReleased(stack, false);
                }
            }
            this.updateRelic(stack, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        this.addBindInfo(tooltip, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        if (GuiScreen.func_146272_n()) {
            if (!this.hasUUID(stack)) {
                ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicUnbound", (Object[])new Object[0]), list);
            } else if (!this.getSoulbindUUID(stack).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.notYourSagittarius", (Object[])new Object[0]), list);
            } else {
                ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{Minecraft.func_71410_x().field_71439_g.func_70005_c_()}), list);
            }
        } else {
            ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    private static void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void updateRelic(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.func_110124_au(), stack);
            if (player instanceof EntityPlayerMP) {
                RelicBindTrigger.INSTANCE.trigger((EntityPlayerMP)player, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemAchilleshield.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(EntityPlayer player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.func_110124_au());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public float getPixieChance(ItemStack arg0) {
        return 1.0f;
    }

    @Override
    public String getAdvancementName(ItemStack stack) {
        return "gaiaDefeat";
    }
}

