/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.relic;

import com.google.common.collect.Multimap;
import com.meteor.extrabotany.api.item.IAdvancementRequired;
import com.meteor.extrabotany.common.brew.ModBrew;
import com.meteor.extrabotany.common.core.network.ExtraBotanyNetwork;
import com.meteor.extrabotany.common.core.network.PacketLeftClickCopy;
import com.meteor.extrabotany.common.item.ModItems;
import com.meteor.extrabotany.common.item.relic.ItemCamera;
import com.meteor.extrabotany.common.item.relic.ItemExcaliber;
import com.meteor.extrabotany.common.item.relic.ItemFailnaught;
import com.meteor.extrabotany.common.item.relic.ItemModRelic;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityManaBurst;

public class ItemBuddhistRelics
extends ItemModRelic
implements IManaUsingItem,
IAdvancementRequired {
    private static final String TAG_MODE = "mode";
    private static final int MODE = 5;
    private static final int MANA_PER_SECONDS = 4;

    public ItemBuddhistRelics() {
        super("buddhistrelics");
        this.func_185043_a(new ResourceLocation("extrabotany", TAG_MODE), (stack, world, entity) -> this.getMode(stack));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            attrib.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", this.getMode(stack) == 4 ? 15.0 : 0.0, 0));
            attrib.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.6, 0));
            attrib.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", this.getMode(stack) == 4 ? 0.3 : 0.0, 1));
        }
        return attrib;
    }

    @SubscribeEvent
    public void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            ExtraBotanyNetwork.sendToServer(new PacketLeftClickCopy());
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent evt) {
        if (!evt.getEntityPlayer().field_70170_p.field_72995_K) {
            this.trySpawnBurst(evt.getEntityPlayer());
        }
    }

    public void trySpawnBurst(EntityPlayer player) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == this && this.getMode(player.func_184614_ca()) == 4 && player.func_184825_o(0.0f) == 1.0f) {
            EntityManaBurst burst = ItemExcaliber.getBurst(player, new ItemStack(ModItems.excaliber));
            player.field_70170_p.func_72838_d((Entity)burst);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.updateRelic(stack, (EntityPlayer)entity);
            if (!ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)entity), (int)4, (boolean)true) && this.getMode(stack) != 0) {
                this.setMode(stack, 0);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int range = 20;
        if (!player.func_70093_af()) {
            if (this.getMode(stack) > 0 && this.getMode(stack) < 4) {
                player.func_184598_c(hand);
                if (this.getMode(stack) == 2) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            if (this.getMode(stack) == 5) {
                ItemCamera camera = new ItemCamera();
                camera.func_77659_a(world, player, hand);
            }
        } else {
            this.switchMode(stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase player) {
        if (this.getMode(stack) == 2 && !world.field_72995_K) {
            for (PotionEffect effect : ModBrew.oneforall.getPotionEffects(stack)) {
                PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), (int)((float)effect.func_76459_b() * 2.0f), effect.func_76458_c() + 1, true, true);
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)player, (Entity)player, player, newEffect.func_76458_c(), 1.0);
                    continue;
                }
                player.func_70690_d(newEffect);
            }
            if (world.field_73012_v.nextBoolean()) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        super.onUsingTick(stack, living, count);
        if (!(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)living;
        if (ManaItemHandler.requestManaExact((ItemStack)stack, (EntityPlayer)player, (int)500, (boolean)true) && this.getMode(stack) == 1 && count % 5 == 0) {
            player.func_71024_bL().func_75122_a(1, 1.0f);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.getMode(stack) == 3) {
            ItemFailnaught failnaught = new ItemFailnaught();
            failnaught.func_77615_a(stack, world, entity, timeLeft);
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        if (this.getMode(stack) == 2) {
            return EnumAction.DRINK;
        }
        if (this.getMode(stack) == 1) {
            return EnumAction.EAT;
        }
        if (this.getMode(stack) == 3) {
            return EnumAction.BOW;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getMode(stack) == 2 ? 18 : 72000;
    }

    public void switchMode(ItemStack stack) {
        if (this.getMode(stack) < 5) {
            this.setMode(stack, this.getMode(stack) + 1);
        } else {
            this.setMode(stack, 0);
        }
    }

    public int getMode(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MODE, (int)0);
    }

    public void setMode(ItemStack stack, int mode) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MODE, (int)mode);
    }

    public boolean usesMana(ItemStack arg0) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnumEnchantmentType cfr_ignored_0 = enchantment.field_77351_y;
        return enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
    }

    @Override
    public String getAdvancementName(ItemStack stack) {
        return "gaiaDefeat";
    }
}

