/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.relic;

import com.google.common.collect.Multimap;
import com.meteor.extrabotany.ExtraBotanyCreativeTab;
import com.meteor.extrabotany.api.item.IAdvancementRequired;
import com.meteor.extrabotany.client.render.IModelReg;
import com.meteor.extrabotany.common.core.network.ExtraBotanyNetwork;
import com.meteor.extrabotany.common.core.network.PacketLeftClickFractal;
import com.meteor.extrabotany.common.entity.EntityItemUnbreakable;
import com.meteor.extrabotany.common.entity.EntityPhantomSword;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemFirstFractal
extends ItemSword
implements IRelic,
IModelReg,
IManaUsingItem,
IAdvancementRequired {
    public static Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)"B_FIRSTFRACTAL", (int)3, (int)-1, (float)5.8f, (float)8.0f, (int)20);
    private static final int MANA_PER_DAMAGE = 160;
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public ItemFirstFractal() {
        this("firstfractal");
    }

    public ItemFirstFractal(String name) {
        super(toolMaterial);
        this.func_77637_a(ExtraBotanyCreativeTab.INSTANCE);
        this.setRegistryName(new ResourceLocation("extrabotany", name));
        this.func_77655_b(name);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent evt) {
        if (!evt.getEntityPlayer().field_70170_p.field_72995_K) {
            this.trySpawnPhantomSword(evt.getEntityPlayer(), evt.getTarget());
        }
    }

    @SubscribeEvent
    public void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            ExtraBotanyNetwork.sendToServer(new PacketLeftClickFractal());
        }
    }

    @SubscribeEvent
    public void leftClick(PlayerInteractEvent.LeftClickBlock evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            ExtraBotanyNetwork.sendToServer(new PacketLeftClickFractal());
        }
    }

    public void trySpawnPhantomSword(EntityPlayer player, Entity target) {
        if (!player.field_70170_p.field_72995_K && !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == this && player.func_184825_o(0.0f) == 1.0f) {
            for (int i = 0; i < 3; ++i) {
                EntityPhantomSword sword = new EntityPhantomSword(player.field_70170_p, (EntityLivingBase)player, target == null ? ToolCommons.raytraceFromEntity((World)player.field_70170_p, (Entity)player, (boolean)false, (double)80.0).func_178782_a().func_177982_a(0, 1, 0) : target.func_180425_c().func_177982_a(0, 1, 0));
                sword.setDelay(5 + 5 * i);
                player.field_70170_p.func_72838_d((Entity)sword);
                ToolCommons.damageItem((ItemStack)player.func_184614_ca(), (int)1, (EntityLivingBase)player, (int)160);
            }
            EntityPhantomSword sword2 = new EntityPhantomSword(player.field_70170_p, (EntityLivingBase)player, target == null ? ToolCommons.raytraceFromEntity((World)player.field_70170_p, (Entity)player, (boolean)false, (double)80.0).func_178782_a().func_177982_a(0, 1, 0) : target.func_180425_c().func_177982_a(0, 1, 0));
            sword2.setVariety(9);
            player.field_70170_p.func_72838_d((Entity)sword2);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
        }
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityItemUnbreakable(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.updateRelic(stack, (EntityPlayer)entity);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)entity), (int)(this.getManaPerDamage() * 2), (boolean)true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getManaPerDamage() {
        return 160;
    }

    public boolean usesMana(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        this.addBindInfo(tooltip, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        if (GuiScreen.func_146272_n()) {
            if (!this.hasUUID(stack)) {
                ItemFirstFractal.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicUnbound", (Object[])new Object[0]), list);
            } else if (!this.getSoulbindUUID(stack).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ItemFirstFractal.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.notYourSagittarius", (Object[])new Object[0]), list);
            } else {
                ItemFirstFractal.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{Minecraft.func_71410_x().field_71439_g.func_70005_c_()}), list);
            }
        } else {
            ItemFirstFractal.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    private static void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void updateRelic(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.func_110124_au(), stack);
            if (player instanceof EntityPlayerMP) {
                RelicBindTrigger.INSTANCE.trigger((EntityPlayerMP)player, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemFirstFractal.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(EntityPlayer player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.func_110124_au());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            attrib.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", 0.3, 1));
            attrib.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", 0.15, 1));
            attrib.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", 5.0, 0));
        }
        return attrib;
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item\\.", "item.extrabotany:");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    public String getAdvancementName(ItemStack stack) {
        return "herrscherDefeat";
    }
}

