/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static HashMap<String, Boolean> manual_bool = new HashMap();
    public static HashMap<String, Integer> manual_int = new HashMap();
    public static HashMap<String, int[]> manual_intA = new HashMap();

    @net.minecraftforge.common.config.Config(modid="immersive_energy")
    public static class IEnConfig {
        static Configuration config;
        @SubConfig
        public static Machines machines;
        @SubConfig
        public static Ores ores;

        public static void preInit(FMLPreInitializationEvent event) {
            IEnConfig.onConfigUpdate();
        }

        private static void onConfigUpdate() {
        }

        public static void validateAndMapValues(Class confClass) {
            for (Field f : confClass.getDeclaredFields()) {
                Config.RangeDouble range;
                if (!Modifier.isStatic(f.getModifiers())) continue;
                Mapped mapped = f.getAnnotation(Mapped.class);
                if (mapped != null) {
                    try {
                        Map map;
                        Field mapField;
                        Class c = mapped.mapClass();
                        if (c == null || (mapField = c.getDeclaredField(mapped.mapName())) == null || (map = (Map)mapField.get(null)) == null) continue;
                        map.put(f.getName(), f.get(null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (f.getAnnotation(SubConfig.class) != null) {
                    IEnConfig.validateAndMapValues(f.getType());
                    continue;
                }
                if (f.getAnnotation(Config.RangeDouble.class) != null) {
                    try {
                        range = f.getAnnotation(Config.RangeDouble.class);
                        Object valObj = f.get(null);
                        double val = valObj instanceof Double ? (Double)valObj : (double)((Float)valObj).floatValue();
                        if (val < range.min()) {
                            f.set(null, range.min());
                            continue;
                        }
                        if (!(val > range.max())) continue;
                        f.set(null, range.max());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (f.getAnnotation(Config.RangeInt.class) == null) continue;
                try {
                    range = f.getAnnotation(Config.RangeInt.class);
                    int val = (Integer)f.get(null);
                    if (val < range.min()) {
                        f.set(null, range.min());
                        continue;
                    }
                    if (val <= range.max()) continue;
                    f.set(null, range.max());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
            if (ev.getModID().equals("immersive_energy")) {
                ConfigManager.sync((String)"immersive_energy", (Config.Type)Config.Type.INSTANCE);
                IEnConfig.onConfigUpdate();
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        public static @interface SubConfig {
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        public static @interface Mapped {
            public Class mapClass();

            public String mapName();
        }

        public static class Ores {
            @Config.Comment(value={"Generation config for Thorium Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_thorium = new int[]{5, 8, 24, 2, 80};
            @Config.Comment(value={"Generation config for Tungsten Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_tungsten = new int[]{2, 8, 24, 2, 30};
            @Config.Comment(value={"Set this to false to disable the logging of the chunks that were flagged for retrogen."})
            public static boolean retrogen_log_flagChunk = true;
            @Config.Comment(value={"Set this to false to disable the logging of the chunks that are still left to retrogen."})
            public static boolean retrogen_log_remaining = true;
            @Config.Comment(value={"The retrogeneration key. Basically IEn checks if this key is saved in the chunks data. If it isn't, it will perform retrogen on all ores marked for retrogen.", "Change this in combination with the retrogen booleans to regen only some of the ores."})
            public static String retrogen_key = "DEFAULT";
            @Config.Comment(value={"Set this to true to allow retro-generation of Thorium Ore."})
            @Mapped(mapClass=IEWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_thorium = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Tungsten Ore."})
            @Mapped(mapClass=IEWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_tungsten = false;
        }

        public static class Machines {
            @Config.Comment(value={"Power config for Solar Panels.", "Parameters: Base gen"})
            @Mapped(mapClass=Config.class, mapName="manual_int")
            public static int base_solar = 16;
            @Config.Comment(value={"Power storage config for Solar Panels.", "Parameters: Storage"})
            @Mapped(mapClass=Config.class, mapName="manual_int")
            public static int storage_solar = Config.IEConfig.Machines.capacitorLV_storage / 4;
            @Config.Comment(value={"Durability of Thorium Rods.", "Parameters: durability"})
            @Config.RangeInt(min=1)
            public static int thoriumRodMaxDamage = 32600;
            @Config.Comment(value={"Decay chance of Thorium Rods.", "Parameters: chance"})
            @Config.RangeInt(min=1)
            public static int thoriumRodDecay = 6538;
            @Config.Comment(value={"Durability of Thorium Rods.", "Parameters: durability"})
            @Config.RangeInt(min=1)
            public static int uraniumRodMaxDamage = 31800;
            @Config.Comment(value={"Decay chance of Uranium Rods.", "Parameters: chance"})
            @Config.RangeInt(min=1)
            public static int uraniumRodDecay = 5338;
        }
    }
}

