/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorMV;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import crimson_twilight.immersive_energy.common.Config;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarPanel
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IDirectionalTile,
ITickable,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.ITileDrop,
EnergyHelper.IIEInternalFluxConnector {
    public boolean active;
    private int energyGeneration;
    public EnumFacing facing = EnumFacing.NORTH;
    boolean inICNet = false;
    public int currentTickAccepted = 0;
    private FluxStorage energyStorage = new FluxStorage(this.getMaxStorage(), this.getMaxInput(), 0);
    boolean firstTick = true;
    EnergyHelper.IEForgeEnergyWrapper energyWrapper;

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.active = nbt.func_74767_n("active");
        this.energyStorage.readFromNBT(nbt);
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74757_a("active", this.active);
        this.energyStorage.writeToNBT(nbt);
    }

    public EnumFacing getFacing() {
        if (this.facing == EnumFacing.DOWN || this.facing == EnumFacing.UP) {
            this.facing = EnumFacing.NORTH;
        }
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            facing = EnumFacing.NORTH;
        }
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    public void func_73660_a() {
        this.energyGeneration = Config.IEnConfig.Machines.base_solar;
        if (!this.field_145850_b.field_72995_K) {
            this.markContainingBlockForUpdate(null);
        }
        this.active = false;
        if (this.field_145850_b.func_72935_r() && this.field_145850_b.func_175710_j(this.func_174877_v())) {
            this.active = true;
            float modifier = 1.0f;
            float f = this.field_145850_b.func_72929_e(1.0f);
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            modifier *= MathHelper.func_76134_b((float)f);
            modifier *= (float)(this.field_145850_b.func_72940_L() / this.field_145850_b.func_72800_K());
            if (this.field_145850_b.func_180494_b(this.field_174879_c).func_150561_m() != null) {
                switch (this.field_145850_b.func_180494_b(this.field_174879_c).func_150561_m()) {
                    case COLD: {
                        modifier *= 0.7f;
                    }
                    case MEDIUM: {
                        modifier *= 1.0f;
                    }
                    case WARM: {
                        modifier *= 1.3f;
                    }
                    case OCEAN: {
                        modifier *= 1.1f;
                    }
                }
                if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_180494_b(this.field_174879_c).func_150561_m() != Biome.TempCategory.WARM) {
                    modifier = modifier * 0.01f / this.field_145850_b.field_73004_o;
                }
                if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_180494_b(this.field_174879_c).func_150561_m() == Biome.TempCategory.WARM) {
                    modifier *= 0.9f;
                }
                if (this.field_145850_b.func_72911_I() && this.field_145850_b.func_180494_b(this.field_174879_c).func_150561_m() != Biome.TempCategory.WARM) {
                    modifier *= 0.001f;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                int temp;
                if ((float)this.energyGeneration * modifier < 1.0f) {
                    this.energyStorage.modifyEnergyStored(-1);
                } else {
                    this.energyStorage.modifyEnergyStored((int)((float)this.energyGeneration * modifier));
                }
                if (this.energyStorage.getEnergyStored() > 0 && (temp = this.transferEnergy(this.energyStorage.getEnergyStored(), true, 0)) > 0) {
                    this.energyStorage.modifyEnergyStored(-this.transferEnergy(temp, false, 0));
                    this.func_70296_d();
                }
                this.currentTickAccepted = 0;
            } else if (this.firstTick) {
                Set conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
                if (conns != null) {
                    for (ImmersiveNetHandler.Connection conn : conns) {
                        if (this.field_174879_c.compareTo((Vec3i)conn.end) >= 0 || !this.field_145850_b.func_175667_e(conn.end)) continue;
                        this.markContainingBlockForUpdate(null);
                    }
                }
                this.firstTick = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o() && ItemNBTHelper.hasKey((ItemStack)stack, (String)"energyStorage")) {
            this.energyStorage.setEnergy(ItemNBTHelper.getInt((ItemStack)stack, (String)"energyStorage"));
        }
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energyStorage", (int)this.energyStorage.getEnergyStored());
        }
        return stack;
    }

    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        return new Vec3d(0.5, (double)0.156f, 0.5);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return new Vec3d(0.5, (double)0.156f, 0.5);
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    protected boolean canTakeLV() {
        return true;
    }

    protected boolean canTakeMV() {
        return true;
    }

    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (facing != this.facing || this.isRelay()) {
            return null;
        }
        if (this.energyWrapper == null || this.energyWrapper.side != this.facing) {
            this.energyWrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, this.facing);
        }
        return this.energyWrapper;
    }

    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return IEEnums.SideConfig.OUTPUT;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return false;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    private int getMaxStorage() {
        return Config.IEnConfig.Machines.storage_solar;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxStorage();
    }

    public int extractEnergy(EnumFacing from, int energy, boolean simulate) {
        return 0;
    }

    public int getMaxInput() {
        return TileEntityConnectorMV.connectorInputValues[1];
    }

    public int getMaxOutput() {
        return TileEntityConnectorMV.connectorInputValues[1];
    }

    public int transferEnergy(int energy, boolean simulate, int energyType) {
        int received = 0;
        if (!this.field_145850_b.field_72995_K) {
            IImmersiveConnectable end;
            int powerLeft;
            Set outputs = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC((Object)((Object)this)), this.field_145850_b);
            int powerForSort = powerLeft = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
            if (outputs.size() < 1) {
                return 0;
            }
            int sum = 0;
            HashMap<ImmersiveNetHandler.AbstractConnection, Integer> powerSorting = new HashMap<ImmersiveNetHandler.AbstractConnection, Integer>();
            for (ImmersiveNetHandler.AbstractConnection con : outputs) {
                int atmOut;
                int tempR;
                end = ApiUtils.toIIC((Object)con.end, (World)this.field_145850_b);
                if (con.cableType == null || end == null || (tempR = end.outputEnergy(atmOut = Math.min(powerForSort, con.cableType.getTransferRate()), true, energyType)) <= 0) continue;
                powerSorting.put(con, tempR);
                sum += tempR;
            }
            if (sum > 0) {
                for (ImmersiveNetHandler.AbstractConnection con : powerSorting.keySet()) {
                    int tempR;
                    end = ApiUtils.toIIC((Object)con.end, (World)this.field_145850_b);
                    if (con.cableType == null || end == null) continue;
                    float prio = (float)((Integer)powerSorting.get(con)).intValue() / (float)sum;
                    int output = (int)((float)powerForSort * prio);
                    int r = tempR = end.outputEnergy(Math.min(output, con.cableType.getTransferRate()), true, energyType);
                    int maxInput = this.getMaxInput();
                    tempR -= (int)Math.max(0.0, Math.floor((float)tempR * con.getPreciseLossRate(tempR, maxInput)));
                    end.outputEnergy(tempR, simulate, energyType);
                    HashSet<IImmersiveConnectable> passedConnectors = new HashSet<IImmersiveConnectable>();
                    float intermediaryLoss = 0.0f;
                    for (ImmersiveNetHandler.Connection sub : con.subConnections) {
                        float length = (float)sub.length / (float)sub.cableType.getMaxLength();
                        float baseLoss = (float)sub.cableType.getLossRatio();
                        float mod = (float)(maxInput - tempR) / (float)maxInput / 0.25f * 0.1f;
                        intermediaryLoss = MathHelper.func_76131_a((float)(intermediaryLoss + length * (baseLoss + baseLoss * mod)), (float)0.0f, (float)1.0f);
                        int transferredPerCon = ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).containsKey(sub) ? (Integer)ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).get(sub) : 0;
                        transferredPerCon += r;
                        if (simulate) continue;
                        ImmersiveNetHandler.INSTANCE.getTransferedRates(this.field_145850_b.field_73011_w.getDimension()).put(sub, transferredPerCon);
                        IImmersiveConnectable subStart = ApiUtils.toIIC((Object)sub.start, (World)this.field_145850_b);
                        IImmersiveConnectable subEnd = ApiUtils.toIIC((Object)sub.end, (World)this.field_145850_b);
                        if (subStart != null && passedConnectors.add(subStart)) {
                            subStart.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                        }
                        if (subEnd == null || !passedConnectors.add(subEnd)) continue;
                        subEnd.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                    }
                    received += r;
                    if ((powerLeft -= r) > 0) continue;
                    break;
                }
            }
        }
        return received;
    }
}

