/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.ModLoadingListener;
import alexiil.mc.mod.load.frame.FrameDisplayer;
import alexiil.mc.mod.load.render.MainSplashRenderer;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="customloadingscreen", guiFactory="alexiil.mc.mod.load.ConfigGuiFactory", acceptableRemoteVersions="*", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class CustomLoadingScreen {
    public static final Configuration CONFIG;
    private static final Property PROP_FRAME;
    private static final Property PROP_USE_CUSTOM;
    private static final Property PROP_CONFIG;
    private static final Property PROP_CONFIG_RANDOMS;
    private static final Property PROP_WAIT;
    private static final Property PROP_FPS_LIMIT;
    private static final Property PROP_DEBUG_RESOURCE_LOADING;
    public static final boolean shouldWait;
    public static final boolean useFrame;
    public static final boolean useCustom;
    public static final boolean darkMode;
    public static final boolean debugResourceLoading;
    public static final String customConfigPath;
    public static final int fpsLimit;
    private static FrameDisplayer displayer;

    public static void finish() {
        if (displayer != null) {
            displayer.finish();
        }
    }

    @Mod.EventHandler
    public static void construct(FMLConstructionEvent event) {
        ModLoadingListener.setup();
        MainSplashRenderer.onReachConstruct();
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(CustomLoadingScreen.class);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    private static void ln(BufferedWriter bw, String str) throws IOException {
        bw.write(str.replace('#', '\"'));
        bw.newLine();
    }

    private static void writeExampleCfg(BufferedWriter bw) throws IOException {
        CustomLoadingScreen.ln(bw, "{");
        CustomLoadingScreen.ln(bw, "    #renders#: [");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#: #builtin/panorama#,");
        CustomLoadingScreen.ln(bw, "                #image#: #textures/gui/title/background/panorama_x.png#");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        },");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#: #builtin/image#,");
        CustomLoadingScreen.ln(bw, "                #image#: #customloadingscreen:textures/generic/darkened_blur_horizontal_strip.png#,");
        CustomLoadingScreen.ln(bw, "                #position_type#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #offset_pos#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #position#: {");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #screen_width#,");
        CustomLoadingScreen.ln(bw, "                    #height#: #100#");
        CustomLoadingScreen.ln(bw, "                },");
        CustomLoadingScreen.ln(bw, "                #texture#: {");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #1#,");
        CustomLoadingScreen.ln(bw, "                    #height#: #1#");
        CustomLoadingScreen.ln(bw, "                }");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        },");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#:#builtin/image#,");
        CustomLoadingScreen.ln(bw, "                #image#: #customloadingscreen:textures/progress_bars.png#,");
        CustomLoadingScreen.ln(bw, "                #position_type#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #offset_pos#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #position#:{");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#:#20#,");
        CustomLoadingScreen.ln(bw, "                    #width#:#182 * 2#,");
        CustomLoadingScreen.ln(bw, "                    #height#:#20#");
        CustomLoadingScreen.ln(bw, "                },");
        CustomLoadingScreen.ln(bw, "                #texture#:{");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#: #70 / 256.0#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #182 / 256.0#,");
        CustomLoadingScreen.ln(bw, "                    #height#: #10 / 256.0#");
        CustomLoadingScreen.ln(bw, "                }");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        },");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#: #builtin/image#,");
        CustomLoadingScreen.ln(bw, "                #image#: #customloadingscreen:textures/progress_bars.png#,");
        CustomLoadingScreen.ln(bw, "                #position_type#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #offset_pos#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #position#:{");
        CustomLoadingScreen.ln(bw, "                    #x#:#percentage * 182 - 182#,");
        CustomLoadingScreen.ln(bw, "                    #y#:#20#,");
        CustomLoadingScreen.ln(bw, "                    #width#:#percentage * 182 * 2#,");
        CustomLoadingScreen.ln(bw, "                    #height#:#20#");
        CustomLoadingScreen.ln(bw, "                },");
        CustomLoadingScreen.ln(bw, "                #texture#:{");
        CustomLoadingScreen.ln(bw, "                    #x#:#0#,");
        CustomLoadingScreen.ln(bw, "                    #y#:#80 / 256.0#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #percentage * 182 / 256.0#,");
        CustomLoadingScreen.ln(bw, "                    #height#:#10 / 256.0#");
        CustomLoadingScreen.ln(bw, "                }");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        },");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#: #builtin/text#,");
        CustomLoadingScreen.ln(bw, "                #image#: #textures/font/ascii.png#,");
        CustomLoadingScreen.ln(bw, "                #position_type#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #offset_pos#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #text#: #is_reloading ? status : (status  + ': ' + sub_status)#,");
        CustomLoadingScreen.ln(bw, "                #position#: {");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#: #-20#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #height#: #0#");
        CustomLoadingScreen.ln(bw, "                },");
        CustomLoadingScreen.ln(bw, "                #colour#:#0xFF_FF_FF_FF#");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        },");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#: #builtin/text#,");
        CustomLoadingScreen.ln(bw, "                #image#: #textures/font/ascii.png#,");
        CustomLoadingScreen.ln(bw, "                #position_type#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #offset_pos#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #text#: #is_reloading ? sub_status : ''#,");
        CustomLoadingScreen.ln(bw, "                #position#: {");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #height#: #0#");
        CustomLoadingScreen.ln(bw, "                },");
        CustomLoadingScreen.ln(bw, "                #colour#:#0xFF_FF_FF_FF#");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        },");
        CustomLoadingScreen.ln(bw, "        {");
        CustomLoadingScreen.ln(bw, "            #image#: {");
        CustomLoadingScreen.ln(bw, "                #parent#: #builtin/text#,");
        CustomLoadingScreen.ln(bw, "                #image#: #textures/font/ascii.png#,");
        CustomLoadingScreen.ln(bw, "                #position_type#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #offset_pos#: #CENTER#,");
        CustomLoadingScreen.ln(bw, "                #text#: #(floor(percentage * 100)) + '%'#,");
        CustomLoadingScreen.ln(bw, "                #position#: {");
        CustomLoadingScreen.ln(bw, "                    #x#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #y#: #-10#,");
        CustomLoadingScreen.ln(bw, "                    #width#: #0#,");
        CustomLoadingScreen.ln(bw, "                    #height#: #0#");
        CustomLoadingScreen.ln(bw, "                },");
        CustomLoadingScreen.ln(bw, "                #colour#:#0xFF_FF_FF_FF#");
        CustomLoadingScreen.ln(bw, "            }");
        CustomLoadingScreen.ln(bw, "        }");
        CustomLoadingScreen.ln(bw, "    ],");
        CustomLoadingScreen.ln(bw, "    #functions#:[");
        CustomLoadingScreen.ln(bw, "    ],");
        CustomLoadingScreen.ln(bw, "    #factories#:[");
        CustomLoadingScreen.ln(bw, "    ],");
        CustomLoadingScreen.ln(bw, "    #actions#:[");
        CustomLoadingScreen.ln(bw, "    ],");
        CustomLoadingScreen.ln(bw, "    #variables#:{");
        CustomLoadingScreen.ln(bw, "    }");
        CustomLoadingScreen.ln(bw, "}");
    }

    static {
        File clsExample;
        File clsRoot;
        CONFIG = new Configuration(new File("./config/customloadingscreen.cfg"));
        PROP_FRAME = CONFIG.get("general", "use_frame", false);
        PROP_USE_CUSTOM = CONFIG.get("general", "use_custom", true);
        PROP_CONFIG = CONFIG.get("general", "screen_config", "builtin/random");
        PROP_CONFIG.setComment("Sets the config to use for the custom loading screen. Use 'builtin/random' for a random loading screen on each load.\nAlternatively you can prefix this with 'config/' to load from the 'config/customloadingscreen/' directory.\nOr you can use 'sample/slideshow' to display images from config/customloadingscreen/slideshow_#.png.\nOr you can set this to 'config/example' to use the default example config.");
        String[] defaultRandoms = new String[]{"sample/default", "sample/white", "sample/scrolling", "sample_panorama_lower"};
        PROP_CONFIG_RANDOMS = CONFIG.get("general", "random_configs", defaultRandoms);
        PROP_WAIT = CONFIG.get("general", "smooth_init", true);
        PROP_WAIT.setComment("Sleep for a tiny amount of time each mod progress stage to make configs that rely on receiving all mod load stages work a bit better.");
        darkMode = false;
        PROP_DEBUG_RESOURCE_LOADING = CONFIG.get("debug", "resource_loading", false);
        debugResourceLoading = PROP_DEBUG_RESOURCE_LOADING.getBoolean();
        PROP_FPS_LIMIT = CONFIG.get("general", "fps_limit", 75);
        PROP_FPS_LIMIT.setComment("The maximum fps to target for the loading screen. The default is 75. Values between 2 and 300 are allowed.");
        PROP_FPS_LIMIT.setMinValue(2);
        PROP_FPS_LIMIT.setMaxValue(300);
        fpsLimit = Math.max(2, Math.min(300, PROP_FPS_LIMIT.getInt()));
        useCustom = PROP_USE_CUSTOM.getBoolean();
        String customName = PROP_CONFIG.getString();
        if ("builtin/random".equals(customName)) {
            String[] possible = PROP_CONFIG_RANDOMS.getStringList();
            if (possible.length == 0) {
                CLSLog.info("No randoms! Defaulting to sample/generic_error...");
                customConfigPath = "sample/generic_error";
            } else {
                customConfigPath = possible[new Random().nextInt(possible.length)];
            }
        } else {
            customConfigPath = customName == null ? "" : customName;
        }
        useFrame = PROP_FRAME.getBoolean();
        if (useFrame) {
            displayer = new FrameDisplayer();
            displayer.start();
        }
        shouldWait = PROP_WAIT.getBoolean();
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
        if (!(clsRoot = new File("./config/customloadingscreen/")).exists()) {
            clsRoot.mkdir();
        }
        if (!(clsExample = new File(clsRoot, "example.json")).exists()) {
            try (FileOutputStream out = new FileOutputStream(clsExample);){
                BufferedOutputStream bos = new BufferedOutputStream(out);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(bos));
                CustomLoadingScreen.writeExampleCfg(bw);
                bw.flush();
            }
            catch (IOException e) {
                CLSLog.warn("Failed to write the example config file!", e);
            }
        }
    }
}

