/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class JsonConfigLoader<T> {
    private final Class<T> clazz;
    private final File file;
    private final T defaultConfig;

    public JsonConfigLoader(File file, Class<T> clazz, T defaultConfig) {
        this.file = file;
        this.clazz = clazz;
        this.defaultConfig = defaultConfig;
    }

    public void createNew() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.file));
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson(this.defaultConfig));
            writer.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T load() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.file));
            Object object = new Gson().fromJson((Reader)reader, this.clazz);
            return (T)object;
        }
        catch (FileNotFoundException e) {
            this.createNew();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.defaultConfig;
    }
}

