/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.Argument;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.DefaultContexts;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.InternalCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.INodeFunc;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.cast.NodeCasting;

public class GenericExpressionCompiler {
    public static IExpressionNode.INodeLong compileExpressionLong(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionLong(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeLong compileExpressionLong(String function, FunctionContext context) throws InvalidExpressionException {
        IExpressionNode node = InternalCompiler.compileExpression(function, context);
        if (node instanceof IExpressionNode.INodeLong) {
            return (IExpressionNode.INodeLong)node;
        }
        throw new InvalidExpressionException("Not a long " + node);
    }

    public static INodeFunc.INodeFuncLong compileFunctionLong(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionLong(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncLong compileFunctionLong(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        INodeFunc func = InternalCompiler.compileFunction(function, context, args);
        if (func instanceof INodeFunc.INodeFuncLong) {
            return (INodeFunc.INodeFuncLong)func;
        }
        throw new InvalidExpressionException("Not a long " + func);
    }

    public static IExpressionNode.INodeDouble compileExpressionDouble(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionDouble(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeDouble compileExpressionDouble(String function, FunctionContext context) throws InvalidExpressionException {
        return NodeCasting.castToDouble(InternalCompiler.compileExpression(function, context)).inline();
    }

    public static INodeFunc.INodeFuncDouble compileFunctionDouble(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionDouble(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncDouble compileFunctionDouble(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        return NodeCasting.castToDouble(InternalCompiler.compileFunction(function, context, args));
    }

    public static IExpressionNode.INodeBoolean compileExpressionBoolean(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionBoolean(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeBoolean compileExpressionBoolean(String function, FunctionContext context) throws InvalidExpressionException {
        IExpressionNode node = InternalCompiler.compileExpression(function, context);
        if (node instanceof IExpressionNode.INodeBoolean) {
            return (IExpressionNode.INodeBoolean)node;
        }
        throw new InvalidExpressionException("Not a boolean " + node);
    }

    public static INodeFunc.INodeFuncBoolean compileFunctionBoolean(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionBoolean(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncBoolean compileFunctionBoolean(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        INodeFunc func = InternalCompiler.compileFunction(function, context, args);
        if (func instanceof INodeFunc.INodeFuncBoolean) {
            return (INodeFunc.INodeFuncBoolean)func;
        }
        throw new InvalidExpressionException("Not a boolean " + func);
    }

    public static <T> IExpressionNode.INodeObject<T> compileExpressionObject(Class<T> clazz, String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionObject(clazz, function, DefaultContexts.createWithAll());
    }

    public static <T> IExpressionNode.INodeObject<T> compileExpressionObject(Class<T> clazz, String function, FunctionContext context) throws InvalidExpressionException {
        return NodeCasting.castToObject(InternalCompiler.compileExpression(function, context), clazz);
    }

    public static <T> INodeFunc.INodeFuncObject<T> compileFunctionObject(Class<T> clazz, String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionObject(clazz, function, DefaultContexts.createWithAll(), args);
    }

    public static <T> INodeFunc.INodeFuncObject<T> compileFunctionObject(Class<T> clazz, String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        return NodeCasting.castToObject(InternalCompiler.compileFunction(function, context, args), clazz);
    }

    public static IExpressionNode.INodeObject<String> compileExpressionString(String function) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileExpressionString(function, DefaultContexts.createWithAll());
    }

    public static IExpressionNode.INodeObject<String> compileExpressionString(String function, FunctionContext context) throws InvalidExpressionException {
        return NodeCasting.castToString(InternalCompiler.compileExpression(function, context)).inline();
    }

    public static INodeFunc.INodeFuncObject<String> compileFunctionString(String function, Argument ... args) throws InvalidExpressionException {
        return GenericExpressionCompiler.compileFunctionString(function, DefaultContexts.createWithAll(), args);
    }

    public static INodeFunc.INodeFuncObject<String> compileFunctionString(String function, FunctionContext context, Argument ... args) throws InvalidExpressionException {
        return NodeCasting.castToString(InternalCompiler.compileFunction(function, context, args));
    }
}

