/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.model.obj;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.machinemuse.numina.basemod.MuseLogger;
import net.machinemuse.numina.client.model.obj.MuseOBJModel;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.commons.compress.utils.IOUtils;

public enum MuseOBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, MuseOBJModel> cache = new HashMap<ResourceLocation, MuseOBJModel>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();
    private IResourceManager manager;

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        MuseLogger.logger.info("MuseOBJLoader: Domain {} has been added.", (Object)domain.toLowerCase());
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        MuseOBJModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a().replaceFirst("^models/models", "models"));
        if (!this.cache.containsKey(file)) {
            IResource resource = null;
            try {
                try {
                    resource = this.manager.func_110536_a(file);
                }
                catch (FileNotFoundException e) {
                    MuseLogger.logException("failed to load model: ", e);
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                MuseOBJModel.Parser parser = new MuseOBJModel.Parser(resource, this.manager);
                MuseOBJModel model2 = null;
                try {
                    model2 = parser.parse();
                }
                catch (Exception e) {
                    this.errors.put(modelLocation, e);
                }
                finally {
                    this.cache.put(modelLocation, model2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file, (Throwable)this.errors.get(modelLocation));
        }
        return model;
    }
}

