/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import net.machinemuse.numina.basemod.MuseLogger;

public class MuseBiMap<S, T> {
    private BiMap<S, T> theMap = HashBiMap.create();

    public T get(S name) {
        return (T)this.theMap.get(name);
    }

    public Iterable<T> elems() {
        return this.theMap.values();
    }

    public Iterable<S> names() {
        return this.theMap.keySet();
    }

    public T putName(S name, T elem) {
        if (this.theMap.containsKey(name)) {
            MuseLogger.logError(name + " already a member!");
        } else {
            this.theMap.put(name, elem);
        }
        return elem;
    }

    public S putElem(T elem, S name) {
        if (this.theMap.containsKey(name)) {
            MuseLogger.logError(name + " already a member!");
        } else {
            this.theMap.put(name, elem);
        }
        return name;
    }

    public Map<S, T> apply() {
        return this.theMap;
    }

    public Map<T, S> inverse() {
        return this.theMap.inverse();
    }

    public S getName(T elem) {
        return (S)this.theMap.inverse().get(elem);
    }

    public S removeElem(T elem) {
        return (S)this.theMap.inverse().remove(elem);
    }

    public T removeName(S name) {
        return (T)this.theMap.remove(name);
    }
}

