/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.library;

import java.util.ArrayList;
import mrthomas20121.biolib.library.Registry;
import mrthomas20121.tinkers_reforged.library.OredictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.PreferenceCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialGen {
    private Material material;
    private Fluid fluid;
    private int temp;
    private String oredict;
    private ArrayList<OredictEntry> entries = new ArrayList();
    private boolean isGem;

    public MaterialGen(String name, int color, String oredict, int temp, boolean isGem) {
        this.material = new Material("ref_" + name, color);
        this.fluid = new FluidMolten(name, color);
        this.temp = temp;
        this.oredict = oredict;
        this.isGem = isGem;
        if (isGem) {
            this.entries.add(new OredictEntry("gem" + oredict, true));
        } else {
            this.entries.add(new OredictEntry("ingot" + oredict, true));
        }
        this.entries.add(new OredictEntry("block" + oredict));
        this.entries.add(new OredictEntry("dust" + oredict));
        this.entries.add(new OredictEntry("gear" + oredict));
        this.entries.add(new OredictEntry("plate" + oredict));
        this.entries.add(new OredictEntry("nugget" + oredict));
    }

    public MaterialGen(String name, int color, String oredict, int temp) {
        this(name, color, oredict, temp, false);
    }

    public void preInit() {
        FluidRegistry.registerFluid((Fluid)this.fluid);
        this.fluid = FluidRegistry.getFluid((String)this.fluid.getName());
        this.fluid.setTemperature(this.temp);
        FluidRegistry.addBucketForFluid((Fluid)this.fluid);
        Registry.addBToolForgeBlock((String)("block" + this.oredict));
    }

    public void init() {
        this.fluid = FluidRegistry.getFluid((String)this.fluid.getName());
        if (!OreDictionary.getOres((String)("ore" + this.oredict)).isEmpty()) {
            TinkerRegistry.registerMelting((String)("ore" + this.oredict), (Fluid)this.fluid, (int)Material.VALUE_Ore());
        }
        for (OredictEntry entry : this.entries) {
            String ore = entry.getValue();
            if (OreDictionary.getOres((String)ore).isEmpty()) continue;
            if (entry.isRepresentating()) {
                this.material.setRepresentativeItem(ore);
            }
            this.material.addItem(ore, 1, entry.getOredictValue());
        }
        if (this.isGem) {
            this.initGem();
        } else {
            this.initMat();
        }
    }

    private void initMat() {
        this.material.setFluid(this.fluid);
        this.material.setCraftable(false).setCastable(true);
        new MaterialIntegration(this.material, this.fluid, this.oredict).toolforge().integrate();
    }

    private void initGem() {
        this.material.setFluid(this.fluid);
        this.material.setCraftable(false).setCastable(true);
        TinkerSmeltery.registerToolpartMeltingCasting((Material)this.material);
        TinkerSmeltery.registerOredictMeltingCasting((Fluid)this.fluid, (String)this.oredict);
        TinkerRegistry.registerTableCasting((ICastingRecipe)new PreferenceCastingRecipe("gem" + this.oredict, RecipeMatch.ofNBT((ItemStack)TinkerSmeltery.castGem), this.fluid, 144));
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getIdentifier() {
        return this.material.getIdentifier();
    }
}

