/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.modules.tinkers_reforged;

import mrthomas20121.biolib.library.ModuleBase;
import mrthomas20121.tinkers_reforged.ReforgedRegistry;
import mrthomas20121.tinkers_reforged.ReforgedTraits;
import mrthomas20121.tinkers_reforged.config.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.library.MaterialGen;
import mrthomas20121.tinkers_reforged.library.Utils;
import mrthomas20121.tinkers_reforged.library.block.ReforgedBlockGlass;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTraits;

public class MaterialsTinkersReforged
implements ModuleBase {
    public static MaterialGen lavium = new MaterialGen("lavium", 10465113, "Lavium", 800);
    public static MaterialGen qivium = new MaterialGen("qivium", 11498073, "Qivium", 800);
    private FluidMolten kovar_fluid = new FluidMolten("kovar", 5466566);

    public void preInit(FMLPreInitializationEvent fmlPreInitializationEvent) {
        FluidRegistry.registerFluid((Fluid)this.kovar_fluid);
        FluidRegistry.addBucketForFluid((Fluid)this.kovar_fluid);
        if (TinkersReforgedConfig.SettingMaterials.materials.lavium) {
            lavium.preInit();
            lavium.getMaterial().addTrait((ITrait)TinkerTraits.momentum);
            lavium.getMaterial().addTrait((ITrait)ReforgedTraits.lifeSteal, "head");
            TinkerRegistry.addMaterial((Material)lavium.getMaterial());
            TinkerRegistry.addMaterialStats((Material)lavium.getMaterial(), (IMaterialStats)new HeadMaterialStats(1000, 12.2f, 12.2f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.3f, 100), new ExtraMaterialStats(100), new BowMaterialStats(5.2f, 5.1f, 5.2f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.qivium) {
            qivium.preInit();
            qivium.getMaterial().addTrait((ITrait)TinkerTraits.momentum);
            qivium.getMaterial().addTrait((ITrait)ReforgedTraits.pyromency, "head");
            TinkerRegistry.addMaterial((Material)qivium.getMaterial());
            TinkerRegistry.addMaterialStats((Material)qivium.getMaterial(), (IMaterialStats)new HeadMaterialStats(1000, 12.2f, 12.2f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.3f, 100), new ExtraMaterialStats(100), new BowMaterialStats(5.2f, 5.2f, 5.2f)});
        }
    }

    public void init(FMLInitializationEvent fmlInitializationEvent) {
        if (TinkersReforgedConfig.SettingMaterials.materials.lavium) {
            lavium.init();
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.qivium) {
            qivium.init();
        }
        if (TinkersReforgedConfig.SettingGeneral.enableAlloyRecipes) {
            FluidStack ardite = FluidRegistry.getFluidStack((String)"ardite", (int)288);
            FluidStack cobalt = FluidRegistry.getFluidStack((String)"cobalt", (int)288);
            FluidStack purpleslime = FluidRegistry.getFluidStack((String)"purpleslime", (int)144);
            FluidStack glass = FluidRegistry.getFluidStack((String)"glass", (int)1000);
            FluidStack lavium = new FluidStack(FluidRegistry.getFluid((String)"lavium"), 144);
            FluidStack qivium = new FluidStack(FluidRegistry.getFluid((String)"qivium"), 144);
            FluidStack kovar = new FluidStack(FluidRegistry.getFluid((String)"kovar"), 144);
            FluidRegistry.getFluidStack((String)"kovar", (int)144);
            TinkerRegistry.registerAlloy((FluidStack)lavium, (FluidStack[])new FluidStack[]{glass, cobalt, purpleslime});
            TinkerRegistry.registerAlloy((FluidStack)qivium, (FluidStack[])new FluidStack[]{glass, ardite, purpleslime});
            TinkerRegistry.registerAlloy((FluidStack)kovar, (FluidStack[])new FluidStack[]{lavium, qivium});
            TinkerSmeltery.registerOredictMeltingCasting((Fluid)kovar.getFluid(), (String)"Kovar");
        }
        TinkerRegistry.registerTableCasting((ItemStack)new ItemStack(Utils.getItem("kovar_glass"), 1), (ItemStack)new ItemStack(Blocks.field_150359_w), (Fluid)this.kovar_fluid, (int)288);
    }

    public static void registerItems(IForgeRegistry<Item> r) {
        for (Mats mat : Mats.values()) {
            String materialName = StringUtils.capitalize((String)mat.name().toLowerCase());
            for (String p : mat.properties) {
                Item item = MaterialsTinkersReforged.register(r, new Item(), materialName.toLowerCase() + "_" + p.toLowerCase());
                ReforgedRegistry.addItem(item);
                OreDictionary.registerOre((String)(p.toLowerCase() + materialName), (Item)item);
            }
        }
    }

    public static void registerBlocks(IForgeRegistry<Block> r) {
        ReforgedRegistry.addBlock(MaterialsTinkersReforged.register(r, (Block)new ReforgedBlockGlass(), "kovar_glass"));
    }

    public void postInit(FMLPostInitializationEvent fmlPostInitializationEvent) {
    }

    private static Item register(IForgeRegistry<Item> r, Item item, String name) {
        item.setRegistryName("tinkers_reforged", name);
        item.func_77655_b("tinkers_reforged." + name);
        item.func_77637_a(CreativeTabs.field_78035_l);
        r.register((IForgeRegistryEntry)item);
        return item;
    }

    private static Block register(IForgeRegistry<Block> r, Block block, String name) {
        block.setRegistryName("tinkers_reforged", name);
        block.func_149663_c("tinkers_reforged." + name);
        r.register((IForgeRegistryEntry)block);
        return block;
    }

    private static enum Mats {
        KOVAR("ingot", "nugget", "dust", "plate", "gear"),
        LAVIUM("ingot", "nugget", "dust", "plate", "gear"),
        QIVIUM("ingot", "nugget", "dust", "plate", "gear");

        String[] properties;

        private Mats() {
            this("ingot", "nugget");
        }

        private Mats(String ... properties) {
            this.properties = properties;
        }
    }
}

