/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.tools;

import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.List;
import mrthomas20121.tinkers_reforged.tools.Tools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class ToolClub
extends SwordCore {
    private static final TObjectFloatMap<EntityLivingBase> cooldown = new TObjectFloatHashMap();

    public ToolClub() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), PartMaterialType.head((IToolPart)Tools.clubHead)});
        this.addCategory(new Category[]{Category.WEAPON});
    }

    public ToolNBT buildTagData(List<Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 1.0f;
        data.durability = (int)((float)data.durability * 0.7f);
        data.attackSpeedMultiplier = 1.0f;
        return data;
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        EntityLivingBase attacker;
        EntityLivingBase target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        if (!(target instanceof EntityStoneBase) && source instanceof EntityLivingBase && (attacker = (EntityLivingBase)source).func_184614_ca().func_77973_b() instanceof ToolClub) {
            float knockback = 0.0f;
            if (cooldown.get((Object)attacker) == 1.0f) {
                knockback = 1.8f;
            }
            target.func_70024_g((double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof EntityLivingBase && !(event.getTarget() instanceof EntityStoneBase) && player.func_184614_ca().func_77973_b() instanceof ToolClub) {
            cooldown.put((Object)player, player.func_184825_o(0.5f));
        }
    }

    public float damagePotential() {
        return 2.6f;
    }

    public double attackSpeed() {
        return 0.5;
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        return super.dealDamage(stack, player, entity, damage);
    }
}

