/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.trait.modifier;

import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ModDigging
extends ModifierTrait {
    private final int max;

    public ModDigging(int max) {
        super("ref_digging", 11488275);
        this.max = max;
        this.addAspects(new ModifierAspect[]{new ModifierAspect.MultiAspect((IModifier)this, 5, max, 1), ModifierAspect.harvestOnly});
    }

    public ModDigging() {
        this(8);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger((NBTTagCompound)modifierTag);
        ToolNBT toolData = TagUtil.getOriginalToolStats((NBTTagCompound)rootCompound);
        float miningspeed = toolData.speed;
        int level = data.current / this.max;
        for (int count = data.current; count > 0; --count) {
            if (miningspeed <= 10.0f) {
                miningspeed += 0.05f - 0.025f * miningspeed / 10.0f;
                continue;
            }
            miningspeed = miningspeed <= 20.0f ? (float)((double)miningspeed + ((double)0.025f - 0.01 * (double)miningspeed / 20.0)) : (float)((double)miningspeed + 0.015);
        }
        miningspeed += (float)level * 0.25f;
        NBTTagCompound tag = TagUtil.getToolTag((NBTTagCompound)rootCompound);
        miningspeed -= toolData.attack;
        tag.func_74776_a("MiningSpeed", miningspeed += tag.func_74760_g("MiningSpeed"));
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

