/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.materials;

import c4.conarm.lib.materials.ArmorMaterialType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;

public class CoreMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Durability = "stat.core.durability.name";
    public static final String LOC_Defense = "stat.core.defense.name";
    public static final String LOC_DurabilityDesc = "stat.core.durability.desc";
    public static final String LOC_DefenseDesc = "stat.core.defense.desc";
    public static final String COLOR_Durability = CustomFontColor.valueToColorCode((float)1.0f);
    public static final String COLOR_Defense = CustomFontColor.encodeColor((int)215, (int)100, (int)100);
    public final float durability;
    public final float defense;

    public CoreMaterialStats(float durability, float defense) {
        super(ArmorMaterialType.CORE);
        this.durability = durability;
        this.defense = defense;
    }

    public List<String> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(CoreMaterialStats.formatDurability(this.durability));
        info.add(CoreMaterialStats.formatDefense(this.defense));
        return info;
    }

    public static String formatDurability(float durability) {
        return CoreMaterialStats.formatNumber((String)LOC_Durability, (String)COLOR_Durability, (float)durability);
    }

    public static String formatDefense(float defense) {
        return CoreMaterialStats.formatNumber((String)LOC_Defense, (String)COLOR_Defense, (float)defense);
    }

    public List<String> getLocalizedDesc() {
        ArrayList info = Lists.newArrayList();
        info.add(Util.translate((String)LOC_DurabilityDesc, (Object[])new Object[0]));
        info.add(Util.translate((String)LOC_DefenseDesc, (Object[])new Object[0]));
        return info;
    }
}

