/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.traits;

import c4.conarm.lib.traits.AbstractArmorTrait;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class AbstractArmorTraitLeveled
extends AbstractArmorTrait {
    protected final String name;
    protected final int levels;

    public AbstractArmorTraitLeveled(String identifier, int color, int maxLevels, int levels) {
        this(identifier, String.valueOf(levels), color, maxLevels, levels);
    }

    public AbstractArmorTraitLeveled(String identifier, String suffix, int color, int maxLevels, int levels) {
        super(identifier + suffix, color);
        this.name = identifier + "_armor";
        this.levels = levels;
        IModifier modifier = TinkerRegistry.getModifier((String)this.name);
        if (modifier != null) {
            if (modifier instanceof AbstractArmorTraitLeveled && ((AbstractArmorTraitLeveled)modifier).levels > this.levels) {
                TinkerRegistry.registerModifierAlias((IModifier)this, (String)this.name);
            }
        } else {
            TinkerRegistry.registerModifierAlias((IModifier)this, (String)this.name);
        }
        this.aspects.clear();
        this.addAspects(new ModifierAspect[]{new ModifierAspect.LevelAspect((IModifier)this, maxLevels), new ModifierAspect.DataAspect((IModifier)this, color)});
    }

    public void updateNBTforTrait(NBTTagCompound modifierTag, int newColor) {
        super.updateNBTforTrait(modifierTag, newColor);
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        data.level = 0;
        data.write(modifierTag);
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        NBTTagList tagList = TagUtil.getModifiersTagList((NBTTagCompound)rootCompound);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)this.getModifierIdentifier());
        NBTTagCompound tag = new NBTTagCompound();
        if (index > -1) {
            tag = tagList.func_150305_b(index);
        } else {
            index = tagList.func_74745_c();
            tagList.func_74742_a((NBTBase)tag);
        }
        if (!tag.func_74767_n(this.identifier)) {
            ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tag);
            data.level += this.levels;
            data.write(tag);
            tag.func_74757_a(this.identifier, true);
            tagList.func_150304_a(index, (NBTBase)tag);
            TagUtil.setModifiersTagList((NBTTagCompound)rootCompound, (NBTTagList)tagList);
            this.applyModifierEffect(rootCompound);
        }
    }

    public void applyModifierEffect(NBTTagCompound rootCompound) {
    }

    public String getModifierIdentifier() {
        return this.name;
    }

    public String getLocalizedName() {
        String locName = Util.translate((String)"modifier.%s.name", (Object[])new Object[]{this.name});
        if (this.levels > 1) {
            locName = locName + " " + TinkerUtil.getRomanNumeral((int)this.levels);
        }
        return locName;
    }

    public String getLocalizedDesc() {
        return Util.translate((String)"modifier.%s.desc", (Object[])new Object[]{this.name});
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

